/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.CrystalIngredient;
import hellfirepvp.astralsorcery.common.crafting.nojson.starlight.LiquidStarlightRecipe;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedRockCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.item.crystal.ItemRockCrystal;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GrowCrystalSizeRecipe
extends LiquidStarlightRecipe {
    public GrowCrystalSizeRecipe() {
        super(AstralSorcery.key("crystal_grow"));
    }

    @Override
    public List<Ingredient> getInputForRender() {
        return Collections.singletonList(new CrystalIngredient(false, false));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getOutputForRender() {
        return Collections.singletonList(new CrystalIngredient(false, false));
    }

    @Override
    public boolean doesStartRecipe(ItemStack item) {
        if (!((Boolean)CraftingConfig.CONFIG.liquidStarlightCrystalGrowth.get()).booleanValue()) {
            return false;
        }
        return !item.func_190926_b() && item.func_77973_b() instanceof ItemCrystalBase;
    }

    @Override
    public boolean matches(ItemEntity trigger, World world, BlockPos at) {
        List<Entity> otherEntities = this.getEntitiesInBlock((IWorld)world, at);
        otherEntities.remove(trigger);
        return otherEntities.isEmpty();
    }

    @Override
    public void doServerCraftTick(ItemEntity trigger, World world, BlockPos at) {
        ItemStack stack;
        CrystalAttributes attr;
        Random r = new Random(MathHelper.func_180186_a((Vec3i)at));
        if (!world.func_201670_d() && this.getAndIncrementCraftingTick((Entity)trigger) > 200 + r.nextInt(40) && (attr = ((ItemCrystalBase)(stack = trigger.func_92059_d()).func_77973_b()).getAttributes(stack)) != null && world.func_175656_a(at, Blocks.field_150350_a.func_176223_P())) {
            attr = attr.modifyLevel(CrystalPropertiesAS.Properties.PROPERTY_SIZE, 1);
            ((ItemCrystalBase)stack.func_77973_b()).setAttributes(stack, attr);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doClientEffectTick(ItemEntity trigger, World world, BlockPos at) {
        Color c = ColorsAS.DEFAULT_GENERIC_PARTICLE;
        if (trigger.func_92059_d().func_77973_b() instanceof ItemRockCrystal || trigger.func_92059_d().func_77973_b() instanceof ItemAttunedRockCrystal) {
            c = ColorsAS.ROCK_CRYSTAL;
        }
        for (int i = 0; i < 3; ++i) {
            Vector3 pos = Vector3.atEntityCenter((Entity)trigger);
            MiscUtils.applyRandomOffset(pos, rand, 0.15f);
            Vector3 motion = Vector3.RotAxis.Y_AXIS.clone();
            motion.rotate(Math.toRadians(10 + rand.nextInt(20)), Vector3.RotAxis.X_AXIS).rotate((double)rand.nextFloat() * Math.PI * 2.0, Vector3.RotAxis.Y_AXIS).normalize().multiply(0.07f + rand.nextFloat() * 0.04f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(motion)).setScaleMultiplier(0.05f + rand.nextFloat() * 0.2f)).color(VFXColorFunction.constant(c))).setMaxAge(30 + rand.nextInt(20));
        }
    }
}

