/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.starlight;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.CrystalIngredient;
import hellfirepvp.astralsorcery.common.crafting.nojson.starlight.LiquidStarlightRecipe;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MergeCrystalsRecipe
extends LiquidStarlightRecipe {
    public MergeCrystalsRecipe() {
        super(AstralSorcery.key("merge_crystals"));
    }

    @Override
    public List<Ingredient> getInputForRender() {
        return Arrays.asList(new Ingredient[]{new CrystalIngredient(false, false), new CrystalIngredient(false, false)});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Ingredient> getOutputForRender() {
        return Collections.singletonList(new CrystalIngredient(false, false));
    }

    @Override
    public boolean doesStartRecipe(ItemStack item) {
        if (!((Boolean)CraftingConfig.CONFIG.liquidStarlightDropInfusedWood.get()).booleanValue()) {
            return false;
        }
        return !item.func_190926_b() && item.func_77973_b() instanceof ItemCrystalBase;
    }

    @Override
    public boolean matches(ItemEntity trigger, World world, BlockPos at) {
        List<Entity> otherEntities = this.getEntitiesInBlock((IWorld)world, at);
        otherEntities.remove(trigger);
        Optional<Entity> crystalEntity = otherEntities.stream().filter(e -> e instanceof ItemEntity).filter(e -> ((ItemEntity)e).func_92059_d().func_77973_b() instanceof ItemCrystalBase).findFirst();
        return crystalEntity.isPresent() && otherEntities.size() == 1;
    }

    @Override
    public void doServerCraftTick(ItemEntity trigger, World world, BlockPos at) {
        ItemStack crystalFoundTwo;
        ItemStack crystalFoundOne;
        Random r = new Random(MathHelper.func_180186_a((Vec3i)at));
        if (!world.func_201670_d() && this.getAndIncrementCraftingTick((Entity)trigger) > 100 + r.nextInt(40) && (crystalFoundOne = this.consumeItemEntityInBlock((IWorld)world, at, 1, stack -> stack.func_77973_b() instanceof ItemCrystalBase)) != null && (crystalFoundTwo = this.consumeItemEntityInBlock((IWorld)world, at, 1, stack -> stack.func_77973_b() instanceof ItemCrystalBase)) != null && world.func_180501_a(at, Blocks.field_150350_a.func_176223_P(), 11)) {
            ItemCrystalBase crystalOne = (ItemCrystalBase)crystalFoundOne.func_77973_b();
            CrystalAttributes attrOne = crystalOne.getAttributes(crystalFoundOne);
            attrOne = attrOne != null ? attrOne : CrystalAttributes.Builder.newBuilder(false).build();
            ItemCrystalBase crystalTwo = (ItemCrystalBase)crystalFoundTwo.func_77973_b();
            CrystalAttributes attrTwo = crystalTwo.getAttributes(crystalFoundTwo);
            attrTwo = attrTwo != null ? attrTwo : CrystalAttributes.Builder.newBuilder(false).build();
            CrystalAttributes mergeTo = attrOne.getTotalTierLevel() >= attrTwo.getTotalTierLevel() ? attrOne : attrTwo;
            CrystalAttributes mergeFrom = attrOne.getTotalTierLevel() >= attrTwo.getTotalTierLevel() ? attrTwo : attrOne;
            ItemStack resultStack = attrOne.getTotalTierLevel() >= attrTwo.getTotalTierLevel() ? crystalFoundOne.func_77946_l() : crystalFoundTwo.func_77946_l();
            ItemCrystalBase resultCrystal = (ItemCrystalBase)resultStack.func_77973_b();
            CrystalAttributes.Builder resultBuilder = CrystalAttributes.Builder.newBuilder(false).addAll(mergeTo);
            int freeProperties = resultCrystal.getMaxPropertyTiers() - mergeTo.getTotalTierLevel();
            int copyAmount = Math.min(freeProperties, mergeFrom.getTotalTierLevel());
            int mergeCount = 0;
            for (int i = 0; i < copyAmount; ++i) {
                CrystalAttributes.Attribute attr = MiscUtils.getWeightedRandomEntry(mergeFrom.getCrystalAttributes(), rand, CrystalAttributes.Attribute::getTier);
                if (attr == null) continue;
                mergeFrom = mergeFrom.modifyLevel(attr.getProperty(), -1);
                if (rand.nextFloat() <= 1.0f - (float)Math.min(mergeCount, 3) * 0.25f) {
                    resultBuilder.addProperty(attr.getProperty(), 1);
                }
                ++mergeCount;
            }
            resultCrystal.setAttributes(resultStack, resultBuilder.build());
            ItemUtils.dropItemNaturally(world, trigger.func_226277_ct_(), trigger.func_226278_cu_(), trigger.func_226281_cx_(), resultStack);
        }
    }

    @Override
    public void doClientEffectTick(ItemEntity trigger, World world, BlockPos at) {
        int i;
        for (i = 0; i < 3; ++i) {
            Vector3 pos = Vector3.atEntityCenter((Entity)trigger);
            MiscUtils.applyRandomOffset(pos, rand, 0.15f);
            Vector3 motion = Vector3.RotAxis.Y_AXIS.clone();
            motion.rotate(Math.toRadians(10 + rand.nextInt(20)), Vector3.RotAxis.X_AXIS).rotate((double)rand.nextFloat() * Math.PI * 2.0, Vector3.RotAxis.Y_AXIS).normalize().multiply(0.07f + rand.nextFloat() * 0.04f);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(motion)).setScaleMultiplier(0.1f + rand.nextFloat() * 0.2f)).color(VFXColorFunction.WHITE)).setMaxAge(35 + rand.nextInt(20));
        }
        for (i = 0; i < 4; ++i) {
            Vector3 target = Vector3.atEntityCenter((Entity)trigger);
            Vector3 pos = target.clone().add(Vector3.random().normalize().multiply(3.0f + rand.nextFloat()));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.PYRAMID.andThen(VFXAlphaFunction.proximity(target::clone, 2.0f)))).motion(VFXMotionController.target(target::clone, 0.1f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).color(VFXColorFunction.WHITE)).setMaxAge(20 + rand.nextInt(20));
        }
    }
}

