/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomMatcherRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.util.block.BlockMatchInformation;
import hellfirepvp.astralsorcery.common.util.object.PredicateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class BlockTransmutation
extends CustomMatcherRecipe {
    private final BlockState outputState;
    private final double starlight;
    private final IWeakConstellation constellation;
    private ItemStack outputDisplay;
    private List<BlockMatchInformation> stateCheck = new ArrayList<BlockMatchInformation>();
    private Predicate<BlockState> matcher = null;

    public BlockTransmutation(ResourceLocation recipeId, BlockState outState, double starlight) {
        this(recipeId, outState, starlight, null);
    }

    public BlockTransmutation(ResourceLocation recipeId, BlockState outState, double starlight, @Nullable IWeakConstellation constellation) {
        super(recipeId);
        this.outputState = outState;
        this.starlight = starlight;
        this.constellation = constellation;
        this.outputDisplay = new ItemStack((IItemProvider)outState.func_177230_c());
    }

    public boolean matches(@Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IWeakConstellation constellation) {
        if (this.matcher == null) {
            this.matcher = PredicateBuilder.joinOr(this.stateCheck);
        }
        return this.matcher.test(state) && (this.constellation == null || this.constellation.equals(constellation));
    }

    public void addInputOption(BlockMatchInformation test) {
        this.matcher = null;
        this.stateCheck.add(test);
    }

    public List<BlockMatchInformation> getInputOptions() {
        return this.stateCheck;
    }

    @Nonnull
    public BlockState getOutput() {
        return this.outputState;
    }

    public void setOutputDisplay(@Nonnull ItemStack outputDisplay) {
        this.outputDisplay = outputDisplay;
    }

    @Nonnull
    public ItemStack getOutputDisplay() {
        return this.outputDisplay.func_77946_l();
    }

    public double getStarlightRequired() {
        return this.starlight;
    }

    @Nullable
    public IWeakConstellation getRequiredConstellation() {
        return this.constellation;
    }

    @Override
    public CustomRecipeSerializer<?> getSerializer() {
        return RecipeSerializersAS.BLOCK_TRANSMUTATION_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypesAS.TYPE_BLOCK_TRANSMUTATION.getType();
    }
}

