/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingFocusStack;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarCraftingProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileSpectralRelay;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import hellfirepvp.astralsorcery.common.util.tile.TileInventoryFiltered;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class ActiveSimpleAltarRecipe {
    private static final Random rand = new Random();
    private Map<Integer, Object> clientEffectContainer = new HashMap<Integer, Object>();
    private final SimpleAltarRecipe recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;
    private int totalCraftingTime;
    private CraftingState state;
    private CompoundNBT craftingData = new CompoundNBT();
    private List<CraftingFocusStack> focusStacks = new LinkedList<CraftingFocusStack>();

    private ActiveSimpleAltarRecipe(SimpleAltarRecipe recipeToCraft, UUID playerCraftingUUID) {
        this(recipeToCraft, 1, playerCraftingUUID);
    }

    public ActiveSimpleAltarRecipe(SimpleAltarRecipe recipeToCraft, int durationDivisor, UUID playerCraftingUUID) {
        Objects.requireNonNull(recipeToCraft);
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
        this.state = CraftingState.ACTIVE;
        this.totalCraftingTime = recipeToCraft.getDuration() / durationDivisor;
    }

    private void recoverContainedEffects(@Nullable ActiveSimpleAltarRecipe previous) {
        if (previous != null && previous.getRecipeToCraft().func_199560_c().equals((Object)this.recipeToCraft.func_199560_c())) {
            this.clientEffectContainer.putAll(previous.clientEffectContainer);
        }
    }

    public CompoundNBT getCraftingData() {
        return this.craftingData;
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    public void setState(CraftingState state) {
        this.state = state;
    }

    public CraftingState getState() {
        return this.state;
    }

    public List<CraftingFocusStack> getFocusStacks() {
        return this.focusStacks;
    }

    @Nullable
    public PlayerEntity tryGetCraftingPlayerServer() {
        MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        return srv.func_184103_al().func_177451_a(this.getPlayerCraftingUUID());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> T getEffectContained(int index, Function<Integer, T> provider) {
        return (T)this.clientEffectContainer.computeIfAbsent(index, provider);
    }

    public void createItemOutputs(TileAltar altar, Consumer<ItemStack> output) {
        Consumer<ItemStack> informer = stack -> ResearchManager.informCraftedAltar(altar, this, stack);
        Consumer<ItemStack> handleCrafted = informer.andThen(output);
        this.getRecipeToCraft().getOutputs(altar).forEach(handleCrafted);
        this.getRecipeToCraft().onRecipeCompletion(altar, this);
    }

    public void consumeInputs(TileAltar altar) {
        TileInventoryFiltered inv = altar.getInventory();
        for (int slot = 0; slot < 25; ++slot) {
            ItemUtils.decrementItem(inv, slot, altar::dropItemOnTop);
        }
        for (CraftingFocusStack input : this.focusStacks) {
            TileSpectralRelay tar = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), input.getRealPosition(), TileSpectralRelay.class, true);
            if (tar == null) continue;
            TileInventory tarInventory = tar.getInventory();
            ItemUtils.decrementItem(tarInventory, 0, altar::dropItemOnTop);
        }
    }

    public boolean matches(TileAltar altar, boolean ignoreStarlightRequirement) {
        if (!this.getRecipeToCraft().matches(LogicalSide.SERVER, this.tryGetCraftingPlayerServer(), altar, ignoreStarlightRequirement)) {
            return false;
        }
        List<WrappedIngredient> listIngredients = this.getRecipeToCraft().getRelayInputs();
        for (CraftingFocusStack stack : this.focusStacks) {
            if (stack.getStackIndex() >= 0 && stack.getStackIndex() < listIngredients.size()) {
                TileSpectralRelay relay = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), stack.getRealPosition(), TileSpectralRelay.class, true);
                if (relay != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public CraftingState tick(TileAltar altar) {
        boolean shouldWait;
        if (this.recipeToCraft instanceof AltarCraftingProgress && !((AltarCraftingProgress)((Object)this.recipeToCraft)).tryProcess(altar, this, this.craftingData, this.ticksCrafting, this.totalCraftingTime)) {
            return CraftingState.WAITING;
        }
        List<WrappedIngredient> iIngredients = this.getRecipeToCraft().getRelayInputs();
        if (!iIngredients.isEmpty() && (shouldWait = this.tickCraftingRelayInputs(altar, iIngredients))) {
            return CraftingState.WAITING;
        }
        ++this.ticksCrafting;
        return CraftingState.ACTIVE;
    }

    private boolean tickCraftingRelayInputs(TileAltar altar, List<WrappedIngredient> iIngredients) {
        int part = this.totalCraftingTime / 3;
        int cttPart = part / iIngredients.size() + 1;
        boolean waitMissingInputs = false;
        for (int i = 0; i < iIngredients.size(); ++i) {
            TileSpectralRelay tar;
            int index = i;
            int offset = part + index * cttPart;
            if (this.ticksCrafting < offset) continue;
            CraftingFocusStack found = MiscUtils.iterativeSearch(this.focusStacks, fStack -> fStack.getStackIndex() == index);
            if (found == null) {
                Set<BlockPos> relays = altar.nearbyRelays();
                relays.removeIf(pos -> MiscUtils.contains(this.focusStacks, fs -> fs.getRealPosition().equals(pos)));
                if (relays.isEmpty()) {
                    waitMissingInputs = true;
                    continue;
                }
                BlockPos at = MiscUtils.getRandomEntry(relays, rand);
                TileSpectralRelay tar2 = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), at, TileSpectralRelay.class, true);
                if (tar2 == null) {
                    waitMissingInputs = true;
                    continue;
                }
                found = new CraftingFocusStack(index, at);
                this.focusStacks.add(found);
            }
            if ((tar = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), found.getRealPosition(), TileSpectralRelay.class, true)) == null) {
                waitMissingInputs = true;
                continue;
            }
            WrappedIngredient input = iIngredients.get(i);
            if (input.getIngredient().test(tar.getInventory().getStackInSlot(0))) continue;
            waitMissingInputs = true;
        }
        return waitMissingInputs;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public int getTotalCraftingTime() {
        return this.totalCraftingTime;
    }

    public SimpleAltarRecipe getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public boolean isFinished() {
        return this.ticksCrafting >= this.totalCraftingTime;
    }

    @Nullable
    public static ActiveSimpleAltarRecipe deserialize(CompoundNBT compound, @Nullable ActiveSimpleAltarRecipe previous) {
        RecipeManager mgr = RecipeHelper.getRecipeManager();
        if (mgr == null) {
            return null;
        }
        ResourceLocation recipeKey = new ResourceLocation(compound.func_74779_i("recipeToCraft"));
        Optional recipe = mgr.func_215367_a(recipeKey);
        if (!recipe.isPresent() || !(recipe.get() instanceof SimpleAltarRecipe)) {
            AstralSorcery.log.info("Recipe with unknown/invalid name found: " + recipeKey);
            return null;
        }
        SimpleAltarRecipe altarRecipe = (SimpleAltarRecipe)recipe.get();
        UUID uuidCraft = compound.func_186857_a("playerCraftingUUID");
        int tick = compound.func_74762_e("ticksCrafting");
        int total = compound.func_74762_e("totalCraftingTime");
        CraftingState state = CraftingState.values()[compound.func_74762_e("state")];
        LinkedList<CraftingFocusStack> stacks = new LinkedList<CraftingFocusStack>();
        ListNBT listStacks = compound.func_150295_c("focusStacks", 10);
        for (int i = 0; i < listStacks.size(); ++i) {
            stacks.add(new CraftingFocusStack(listStacks.func_150305_b(i)));
        }
        ActiveSimpleAltarRecipe task = new ActiveSimpleAltarRecipe(altarRecipe, uuidCraft);
        task.ticksCrafting = tick;
        task.totalCraftingTime = total;
        task.setState(state);
        task.craftingData = compound.func_74775_l("craftingData");
        task.focusStacks = stacks;
        task.recoverContainedEffects(previous);
        return task;
    }

    @Nonnull
    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("recipeToCraft", this.getRecipeToCraft().func_199560_c().toString());
        compound.func_186854_a("playerCraftingUUID", this.getPlayerCraftingUUID());
        compound.func_74768_a("ticksCrafting", this.getTicksCrafting());
        compound.func_74768_a("totalCraftingTime", this.getTotalCraftingTime());
        compound.func_74768_a("state", this.getState().ordinal());
        compound.func_218657_a("craftingData", (INBT)this.craftingData);
        ListNBT list = new ListNBT();
        for (CraftingFocusStack stack : this.focusStacks) {
            list.add((Object)stack.serialize());
        }
        compound.func_218657_a("focusStacks", (INBT)list);
        return compound;
    }

    public static enum CraftingState {
        ACTIVE,
        WAITING;

    }
}

