/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationBaseItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConstellationBaseItemRecipe
extends SimpleAltarRecipe {
    private static final String KEY_CONSTELLATION = "constellation";
    private IConstellation constellation = null;

    public ConstellationBaseItemRecipe(ResourceLocation recipeId, AltarType altarType, int duration, int starlightRequirement, AltarRecipeGrid recipeGrid) {
        super(recipeId, altarType, duration, starlightRequirement, recipeGrid);
    }

    public static ConstellationBaseItemRecipe convertToThis(SimpleAltarRecipe other) {
        return new ConstellationBaseItemRecipe(other.func_199560_c(), other.getAltarType(), other.getDuration(), other.getStarlightRequirement(), other.getInputs());
    }

    @Override
    public void deserializeAdditionalJson(JsonObject recipeObject) throws JsonSyntaxException {
        ResourceLocation cstName;
        IConstellation cst;
        super.deserializeAdditionalJson(recipeObject);
        if (JSONUtils.func_151204_g((JsonObject)recipeObject, (String)KEY_CONSTELLATION) && (cst = (IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(cstName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)recipeObject, (String)KEY_CONSTELLATION)))) != null) {
            this.setConstellation(cst);
        }
    }

    @Override
    public void serializeAdditionalJson(JsonObject recipeObject) {
        super.serializeAdditionalJson(recipeObject);
        if (this.getConstellation() != null) {
            recipeObject.addProperty(KEY_CONSTELLATION, this.getConstellation().getRegistryName().toString());
        }
    }

    public void setConstellation(IConstellation constellation) {
        this.constellation = constellation;
    }

    public IConstellation getConstellation() {
        return this.constellation;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getOutputForRender(Iterable<ItemStack> inventoryContents) {
        ItemStack out = super.getOutputForRender(inventoryContents);
        this.setConstellations(out);
        return out;
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputs(TileAltar altar) {
        List<ItemStack> out = super.getOutputs(altar);
        out.forEach(this::setConstellations);
        return out;
    }

    private void setConstellations(ItemStack out) {
        if (out.func_77973_b() instanceof ConstellationBaseItem && this.getConstellation() != null) {
            ((ConstellationBaseItem)out.func_77973_b()).setConstellation(out, this.getConstellation());
        }
    }

    @Override
    public void writeRecipeSync(PacketBuffer buf) {
        super.writeRecipeSync(buf);
        ByteBufUtils.writeOptional(buf, this.getConstellation(), ByteBufUtils::writeRegistryEntry);
    }

    @Override
    public void readRecipeSync(PacketBuffer buf) {
        super.readRecipeSync(buf);
        this.setConstellation(ByteBufUtils.readOptional(buf, ByteBufUtils::readRegistryEntry));
    }
}

