/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin;

import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseItemRecipe;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ConstellationBaseMergeStatsRecipe
extends ConstellationBaseItemRecipe {
    public ConstellationBaseMergeStatsRecipe(ResourceLocation recipeId, AltarType altarType, int duration, int starlightRequirement, AltarRecipeGrid recipeGrid) {
        super(recipeId, altarType, duration, starlightRequirement, recipeGrid);
    }

    public static ConstellationBaseMergeStatsRecipe convertToThis(SimpleAltarRecipe other) {
        return new ConstellationBaseMergeStatsRecipe(other.func_199560_c(), other.getAltarType(), other.getDuration(), other.getStarlightRequirement(), other.getInputs());
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender(Iterable<ItemStack> inventoryContents) {
        ItemStack out = super.getOutputForRender(inventoryContents);
        this.setStats(out, inventoryContents);
        return out;
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputs(TileAltar altar) {
        List<ItemStack> out = super.getOutputs(altar);
        out.forEach(stack -> this.setStats((ItemStack)stack, altar.getInventory()));
        return out;
    }

    private void setStats(ItemStack out, Iterable<ItemStack> inventoryContents) {
        if (!(out.func_77973_b() instanceof CrystalAttributeItem)) {
            return;
        }
        CrystalAttributes.Builder builder = CrystalAttributes.Builder.newBuilder(true);
        for (ItemStack stack : inventoryContents) {
            CrystalAttributes attr;
            if (!(stack.func_77973_b() instanceof CrystalAttributeItem) || (attr = ((CrystalAttributeItem)stack.func_77973_b()).getAttributes(stack)) == null) continue;
            builder.addAll(attr);
        }
        CrystalAttributes attr = builder.build();
        if (!attr.isEmpty()) {
            ((CrystalAttributeItem)out.func_77973_b()).setAttributes(out, attr);
        }
    }
}

