/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin.ConstellationBaseAverageStatsRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ConstellationCopyStatsRecipe
extends ConstellationBaseAverageStatsRecipe {
    private static final String KEY_CONSTELLATION_SLOT = "constellationSlot";
    private int constellationSlot = -1;

    public ConstellationCopyStatsRecipe(ResourceLocation recipeId, AltarType altarType, int duration, int starlightRequirement, AltarRecipeGrid recipeGrid) {
        super(recipeId, altarType, duration, starlightRequirement, recipeGrid);
    }

    public static ConstellationCopyStatsRecipe convertToThis(SimpleAltarRecipe other) {
        return new ConstellationCopyStatsRecipe(other.func_199560_c(), other.getAltarType(), other.getDuration(), other.getStarlightRequirement(), other.getInputs());
    }

    public void setConstellationSlot(int constellationSlot) {
        this.constellationSlot = constellationSlot;
    }

    public int getConstellationSlot() {
        return this.constellationSlot;
    }

    @Override
    public void deserializeAdditionalJson(JsonObject recipeObject) throws JsonSyntaxException {
        super.deserializeAdditionalJson(recipeObject);
        if (JSONUtils.func_151204_g((JsonObject)recipeObject, (String)KEY_CONSTELLATION_SLOT)) {
            this.constellationSlot = JSONUtils.func_151203_m((JsonObject)recipeObject, (String)KEY_CONSTELLATION_SLOT);
        }
    }

    @Override
    public void serializeAdditionalJson(JsonObject recipeObject) {
        super.serializeAdditionalJson(recipeObject);
        if (this.constellationSlot != -1) {
            recipeObject.addProperty(KEY_CONSTELLATION_SLOT, (Number)this.constellationSlot);
        }
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender(Iterable<ItemStack> inventoryContents) {
        ItemStack out = super.getOutputForRender(inventoryContents);
        this.copyConstellation(out, inventoryContents);
        return out;
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputs(TileAltar altar) {
        List<ItemStack> out = super.getOutputs(altar);
        out.forEach(stack -> this.copyConstellation((ItemStack)stack, altar.getInventory()));
        return out;
    }

    private void copyConstellation(ItemStack out, Iterable<ItemStack> inventoryContents) {
        ConstellationItem iOut;
        if (out.func_77973_b() instanceof ConstellationItem && ((iOut = (ConstellationItem)out.func_77973_b()).getAttunedConstellation(out) == null || iOut.getTraitConstellation(out) == null)) {
            if (this.constellationSlot >= 0) {
                inventoryContents = Iterables.concat((Iterable)Lists.newArrayList((Object[])new ItemStack[]{(ItemStack)Iterables.get(inventoryContents, (int)this.constellationSlot, (Object)ItemStack.field_190927_a)}), inventoryContents);
            }
            for (ItemStack stack : inventoryContents) {
                IConstellation c;
                if (!(stack.func_77973_b() instanceof ConstellationItem)) continue;
                if (iOut.getAttunedConstellation(out) == null && (c = ((ConstellationItem)stack.func_77973_b()).getAttunedConstellation(stack)) != null) {
                    iOut.setAttunedConstellation(out, (IWeakConstellation)c);
                }
                if (iOut.getTraitConstellation(out) != null || (c = ((ConstellationItem)stack.func_77973_b()).getTraitConstellation(stack)) == null) continue;
                iOut.setTraitConstellation(out, (IMinorConstellation)c);
            }
        }
    }
}

