/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar.builtin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class NBTCopyRecipe
extends SimpleAltarRecipe {
    private static final String KEY_SEARCH_ITEMS = "copy_nbt_from_items_matching";
    private List<Ingredient> searchIngredients = Lists.newArrayList();

    public NBTCopyRecipe(ResourceLocation recipeId, AltarType altarType, int duration, int starlightRequirement, AltarRecipeGrid recipeGrid) {
        super(recipeId, altarType, duration, starlightRequirement, recipeGrid);
    }

    public static NBTCopyRecipe convertToThis(SimpleAltarRecipe other) {
        return new NBTCopyRecipe(other.func_199560_c(), other.getAltarType(), other.getDuration(), other.getStarlightRequirement(), other.getInputs());
    }

    public <T extends NBTCopyRecipe> T addNBTCopyMatchIngredient(Tag<Item> tag) {
        return this.addNBTCopyMatchIngredient(Ingredient.func_199805_a(tag));
    }

    public <T extends NBTCopyRecipe> T addNBTCopyMatchIngredient(ItemStack ... items) {
        return this.addNBTCopyMatchIngredient(Ingredient.func_193369_a((ItemStack[])items));
    }

    public <T extends NBTCopyRecipe> T addNBTCopyMatchIngredient(IItemProvider ... items) {
        return this.addNBTCopyMatchIngredient(Ingredient.func_199804_a((IItemProvider[])items));
    }

    public <T extends NBTCopyRecipe> T addNBTCopyMatchIngredient(Ingredient ingredient) {
        this.searchIngredients.add(ingredient);
        return (T)this;
    }

    @Override
    public void deserializeAdditionalJson(JsonObject recipeObject) throws JsonSyntaxException {
        super.deserializeAdditionalJson(recipeObject);
        JsonArray list = JSONUtils.func_151213_a((JsonObject)recipeObject, (String)KEY_SEARCH_ITEMS, (JsonArray)new JsonArray());
        for (JsonElement element : list) {
            this.searchIngredients.add(Ingredient.func_199802_a((JsonElement)element));
        }
    }

    @Override
    public void serializeAdditionalJson(JsonObject recipeObject) {
        super.serializeAdditionalJson(recipeObject);
        JsonArray list = new JsonArray();
        for (Ingredient ingredient : this.searchIngredients) {
            list.add(ingredient.func_200304_c());
        }
        recipeObject.add(KEY_SEARCH_ITEMS, (JsonElement)list);
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputs(TileAltar altar) {
        List<ItemStack> outputs = super.getOutputs(altar);
        ArrayList foundTags = Lists.newArrayList();
        for (ItemStack existing : altar.getInventory()) {
            for (Ingredient match : this.searchIngredients) {
                if (!match.test(existing) || !existing.func_77942_o()) continue;
                foundTags.add(existing.func_77978_p().func_74737_b());
            }
        }
        for (ItemStack output : outputs) {
            CompoundNBT tag = output.func_196082_o();
            for (CompoundNBT foundTag : foundTags) {
                NBTHelper.deepMerge(tag, foundTag);
            }
        }
        return outputs;
    }

    @Override
    public void readRecipeSync(PacketBuffer buf) {
        super.readRecipeSync(buf);
        this.searchIngredients = ByteBufUtils.readList(buf, Ingredient::func_199566_b);
    }

    @Override
    public void writeRecipeSync(PacketBuffer buf) {
        super.writeRecipeSync(buf);
        ByteBufUtils.writeList(buf, this.searchIngredients, (buffer, ingredient) -> ingredient.func_199564_a(buffer));
    }
}

