/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect;

import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.ColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.crafting.helper.CraftingFocusStack;
import hellfirepvp.astralsorcery.common.crafting.helper.WrappedIngredient;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.ActiveSimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.AltarRecipeEffect;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileSpectralRelay;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuiltInEffectTraitRelayHighlight
extends AltarRecipeEffect {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTick(TileAltar altar, ActiveSimpleAltarRecipe.CraftingState state) {
        ActiveSimpleAltarRecipe recipe = altar.getActiveRecipe();
        if (recipe != null) {
            List<WrappedIngredient> additionalIngredients = recipe.getRecipeToCraft().getRelayInputs();
            for (CraftingFocusStack stack : recipe.getFocusStacks()) {
                if (stack.getStackIndex() < 0 || stack.getStackIndex() >= additionalIngredients.size()) continue;
                WrappedIngredient match = additionalIngredients.get(stack.getStackIndex());
                TileSpectralRelay relay = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), stack.getRealPosition(), TileSpectralRelay.class, false);
                if (relay == null) continue;
                ItemStack in = relay.getInventory().getStackInSlot(0);
                if (!in.func_190926_b() && match.getIngredient().test(in)) {
                    Color color = ColorizationHelper.getColor(in).orElse(ColorsAS.CELESTIAL_CRYSTAL);
                    this.playLightbeam(altar, relay, color);
                    this.playRelayHighlightParticles(relay, color);
                    if (rand.nextInt(4) != 0) continue;
                    ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(altar).add((double)(-3 + rand.nextInt(7)), 0.02, (double)(-3 + rand.nextInt(7))))).color(VFXColorFunction.constant(color))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.2f);
                    continue;
                }
                ItemStack chosen = match.getRandomMatchingStack(this.getClientTick());
                Color color = ColorizationHelper.getColor(chosen).orElse(ColorsAS.CELESTIAL_CRYSTAL);
                this.playLightbeam(altar, relay, color);
                this.playRelayHighlightParticles(relay, color);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playRelayHighlightParticles(TileSpectralRelay relay, Color color) {
        if (rand.nextBoolean()) {
            FXFacingParticle particle = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(relay).add(rand.nextFloat(), 0.0f, rand.nextFloat()))).setAlphaMultiplier(0.7f)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(30 + rand.nextInt(50));
            if (rand.nextInt(3) == 0) {
                ((EntityVisualFX)particle.color(VFXColorFunction.WHITE)).setScaleMultiplier(0.1f + rand.nextFloat() * 0.1f);
            } else {
                ((EntityVisualFX)particle.color(VFXColorFunction.constant(color))).setGravityStrength(-0.0015f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playLightbeam(TileAltar from, TileSpectralRelay to, Color color) {
        if (this.getClientTick() % 35L == 0L) {
            ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(new Vector3(from).add(0.5, 0.0, 0.5).add(BuiltInEffectTraitRelayHighlight.getFocusRelayOffset(from.getAltarType())))).setup(new Vector3(to).add(0.5, 0.1, 0.5), 0.8f, 0.8f).color(VFXColorFunction.constant(color));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTESR(TileAltar altar, ActiveSimpleAltarRecipe.CraftingState state, MatrixStack renderStack, IRenderTypeBuffer buffer, float pTicks, int combinedLight) {
        ActiveSimpleAltarRecipe activeRecipe = altar.getActiveRecipe();
        if (activeRecipe != null) {
            List<WrappedIngredient> additionalIngredients = activeRecipe.getRecipeToCraft().getRelayInputs();
            List<CraftingFocusStack> focusStacks = activeRecipe.getFocusStacks();
            for (CraftingFocusStack stack : focusStacks) {
                if (stack.getStackIndex() < 0 || stack.getStackIndex() >= additionalIngredients.size()) continue;
                WrappedIngredient match = additionalIngredients.get(stack.getStackIndex());
                BlockPos offset = stack.getRealPosition().func_177973_b((Vec3i)altar.func_174877_v());
                TileSpectralRelay relay = MiscUtils.getTileAt((IBlockReader)altar.func_145831_w(), stack.getRealPosition(), TileSpectralRelay.class, false);
                if (relay != null && match.getIngredient().test(relay.getInventory().getStackInSlot(0))) continue;
                ItemStack potential = match.getRandomMatchingStack(this.getClientTick());
                renderStack.func_227860_a_();
                renderStack.func_227861_a_(0.5 + (double)offset.func_177958_n(), 0.35 + (double)offset.func_177956_o(), 0.5 + (double)offset.func_177952_p());
                renderStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                RenderingUtils.renderTranslucentItemStack(potential, renderStack, pTicks);
                renderStack.func_227865_b_();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onCraftingFinish(TileAltar altar, boolean isChaining) {
    }
}

