/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal;

import hellfirepvp.astralsorcery.common.crystal.calc.PropertySource;
import hellfirepvp.astralsorcery.common.crystal.calc.PropertyUsage;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CalculationContext {
    private Collection<PropertyUsage> usages = new HashSet<PropertyUsage>();
    private PropertySource.SourceInstance source = null;

    private CalculationContext() {
    }

    public boolean uses(PropertyUsage usage) {
        return this.usages.contains((Object)usage);
    }

    public double withUse(PropertyUsage usage, double defaultValue, Supplier<Double> valueSupplier) {
        if (this.uses(usage)) {
            return valueSupplier.get();
        }
        return defaultValue;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public boolean isSource(PropertySource<?, ?> source) {
        return this.isSource(source::equals);
    }

    public boolean isSource(Predicate<PropertySource<?, ?>> sourceTest) {
        return this.hasSource() && sourceTest.test(this.source.getSource());
    }

    public <T extends PropertySource.SourceInstance> T getSource() {
        if (this.hasSource()) {
            return (T)this.source;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.usages.isEmpty() && this.source == null;
    }

    public static class Builder {
        private CalculationContext ctx = new CalculationContext();

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder withUsage(PropertyUsage usage) {
            return Builder.newBuilder().addUsage(usage);
        }

        public static Builder withSource(PropertySource.SourceInstance source) {
            return Builder.newBuilder().fromSource(source);
        }

        public Builder addUsage(PropertyUsage usage) {
            this.ctx.usages.add(usage);
            return this;
        }

        public Builder fromSource(PropertySource.SourceInstance source) {
            this.ctx.source = source;
            return this;
        }

        public CalculationContext build() {
            return this.ctx;
        }
    }
}

