/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeGenItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalProperty;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class CrystalGenerator {
    private static final int COUNT_PHYSICAL_PROPERTY_TIERS = 5;
    private static final float CHANCE_PHYSICAL_PROPERTIES = 0.8f;
    private static final List<CrystalProperty> PHYSICAL_PROPERTIES = Lists.newArrayList((Object[])new CrystalProperty[]{CrystalPropertiesAS.Properties.PROPERTY_SIZE, CrystalPropertiesAS.Properties.PROPERTY_SHAPE, CrystalPropertiesAS.Properties.PROPERTY_PURITY});
    private static final int COUNT_USAGE_PROPERTY_TIERS = 4;
    private static final float CHANCE_USAGE_PROPERTIES = 0.75f;
    private static final List<CrystalProperty> USAGE_PROPERTIES = Lists.newArrayList((Object[])new CrystalProperty[]{CrystalPropertiesAS.Properties.PROPERTY_TOOL_DURABILITY, CrystalPropertiesAS.Properties.PROPERTY_TOOL_EFFICIENCY, CrystalPropertiesAS.Properties.PROPERTY_RITUAL_RANGE, CrystalPropertiesAS.Properties.PROPERTY_RITUAL_EFFECT, CrystalPropertiesAS.Properties.PROPERTY_COLLECTOR_COLLECTION_RATE});
    private static final Random RAND = new Random();

    @Nonnull
    public static CrystalAttributes upgradeProperties(ItemStack stack) {
        return CrystalGenerator.upgradeProperties(stack, RAND);
    }

    @Nonnull
    public static CrystalAttributes upgradeProperties(ItemStack stack, Random random) {
        if (!(stack.func_77973_b() instanceof CrystalAttributeItem)) {
            return CrystalGenerator.generateNewAttributes(stack, random);
        }
        CrystalAttributes attr = ((CrystalAttributeItem)stack.func_77973_b()).getAttributes(stack);
        if (attr == null) {
            return CrystalGenerator.generateNewAttributes(stack, random);
        }
        if (!(stack.func_77973_b() instanceof CrystalAttributeGenItem)) {
            return attr;
        }
        int existing = attr.getTotalTierLevel();
        int expected = MathHelper.func_76125_a((int)(existing + 1), (int)((CrystalAttributeGenItem)stack.func_77973_b()).getGeneratedPropertyTiers(), (int)((CrystalAttributeGenItem)stack.func_77973_b()).getMaxPropertyTiers());
        int generate = expected - attr.getTotalTierLevel();
        CrystalAttributes.Builder builder = CrystalAttributes.Builder.newBuilder(false);
        builder.addAll(attr);
        for (int i = 0; i < generate; ++i) {
            ArrayList<CrystalProperty> remaining = new ArrayList<CrystalProperty>(RegistriesAS.REGISTRY_CRYSTAL_PROPERTIES.getValues());
            while (!CrystalGenerator.addRandomProperty(builder, remaining, random)) {
            }
        }
        return builder.build();
    }

    @Nullable
    public static CrystalProperty getRandomProperty() {
        return CrystalGenerator.getRandomProperty(RAND);
    }

    @Nullable
    public static CrystalProperty getRandomProperty(Random random) {
        if (random.nextFloat() <= 0.8f) {
            return MiscUtils.getRandomEntry(PHYSICAL_PROPERTIES, random);
        }
        if (random.nextFloat() <= 0.75f) {
            return MiscUtils.getRandomEntry(USAGE_PROPERTIES, random);
        }
        ArrayList remaining = new ArrayList(RegistriesAS.REGISTRY_CRYSTAL_PROPERTIES.getValues());
        remaining.removeAll(USAGE_PROPERTIES);
        remaining.removeAll(PHYSICAL_PROPERTIES);
        return (CrystalProperty)MiscUtils.getRandomEntry(remaining, random);
    }

    @Nonnull
    public static CrystalAttributes generateNewAttributes(ItemStack item) {
        return CrystalGenerator.generateNewAttributes(item, RAND);
    }

    @Nonnull
    public static CrystalAttributes generateNewAttributes(ItemStack item, Random random) {
        int x;
        int toGenerate = 4;
        if (item.func_77973_b() instanceof CrystalAttributeGenItem) {
            toGenerate = ((CrystalAttributeGenItem)item.func_77973_b()).getGeneratedPropertyTiers();
        }
        CrystalAttributes.Builder attrBuilder = CrystalAttributes.Builder.newBuilder(false);
        int totalAdded = 0;
        for (x = 0; x < 5 && totalAdded < toGenerate; ++x) {
            if (!(random.nextFloat() <= 0.8f)) continue;
            while (!CrystalGenerator.addRandomProperty(attrBuilder, PHYSICAL_PROPERTIES, random)) {
            }
            ++totalAdded;
        }
        for (x = 0; x < 4 && totalAdded < toGenerate; ++x) {
            if (!(random.nextFloat() <= 0.75f)) continue;
            while (!CrystalGenerator.addRandomProperty(attrBuilder, USAGE_PROPERTIES, random)) {
            }
            ++totalAdded;
        }
        ArrayList<CrystalProperty> remaining = new ArrayList<CrystalProperty>(RegistriesAS.REGISTRY_CRYSTAL_PROPERTIES.getValues());
        remaining.removeAll(USAGE_PROPERTIES);
        remaining.removeAll(PHYSICAL_PROPERTIES);
        while (totalAdded < toGenerate) {
            while (!CrystalGenerator.addRandomProperty(attrBuilder, remaining, random)) {
            }
            ++totalAdded;
        }
        return attrBuilder.build();
    }

    private static boolean addRandomProperty(CrystalAttributes.Builder builder, Collection<CrystalProperty> properties, Random random) {
        List<CrystalProperty> existing = builder.getProperties();
        existing.removeIf(o -> !properties.contains(o));
        existing.removeIf(property -> builder.getPropertyLvl((CrystalProperty)property, 0) >= property.getMaxTier());
        CrystalProperty propExisting = MiscUtils.getRandomEntry(existing, random);
        CrystalProperty prop = random.nextFloat() <= 0.85f && propExisting != null ? propExisting : MiscUtils.getRandomEntry(properties, random);
        int existingLvl = builder.getPropertyLvl(prop, 0);
        if (existingLvl < prop.getMaxTier()) {
            builder.addProperty(prop, 1);
            return true;
        }
        return false;
    }
}

