/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crystal;

import hellfirepvp.astralsorcery.common.crystal.CalculationContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalPropertyModifierFunction;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class CrystalProperty
extends ForgeRegistryEntry<CrystalProperty>
implements Comparable<CrystalProperty> {
    private static int counter = 0;
    private final int sortingId;
    private ResearchProgression requiredResearch = null;
    private List<CrystalPropertyModifierFunction> modifiers = new ArrayList<CrystalPropertyModifierFunction>();
    private Predicate<CalculationContext> usageTests = ctx -> false;

    public CrystalProperty(ResourceLocation registryName) {
        this.sortingId = counter++;
        this.setRegistryName(registryName);
    }

    public CrystalProperty setRequiredResearch(ResearchProgression requiredResearch) {
        this.requiredResearch = requiredResearch;
        return this;
    }

    public CrystalProperty addModifier(CrystalPropertyModifierFunction modifierFunction) {
        this.modifiers.add(modifierFunction);
        return this;
    }

    public CrystalProperty addUsage(Predicate<CalculationContext> usage) {
        this.usageTests = this.usageTests.or(usage);
        return this;
    }

    public int getMaxTier() {
        return 3;
    }

    public boolean canSee(PlayerProgress progress) {
        return this.requiredResearch == null || progress.getResearchProgression().contains((Object)this.requiredResearch);
    }

    public boolean hasUsageFor(CalculationContext ctx) {
        return this.usageTests.test(ctx);
    }

    public double modify(double value, int tier, CalculationContext context) {
        double originalValue = value;
        for (CrystalPropertyModifierFunction fn : this.modifiers) {
            value = fn.modify(value, originalValue, tier, context);
        }
        return value;
    }

    public ITextComponent getName(int currentTier) {
        return new TranslationTextComponent(String.format("crystal.property.%s.%s.name", this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a()), new Object[0]);
    }

    @Override
    public int compareTo(CrystalProperty other) {
        return this.sortingId - other.sortingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrystalProperty that = (CrystalProperty)o;
        return Objects.equals(this.getRegistryName(), that.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.getRegistryName());
    }
}

