/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.base;

import hellfirepvp.astralsorcery.common.data.config.CommonConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public abstract class ConfigEntry
implements Consumer<ForgeConfigSpec.Builder> {
    private Set<ConfigEntry> subSections = new HashSet<ConfigEntry>();
    private final String path;
    private String subPath = "";
    private ModConfig.Type configType;

    public ConfigEntry(String section) {
        this.path = section.toLowerCase();
    }

    public ConfigEntry newSubSection(ConfigEntry entry) {
        entry.subPath = this.getPath();
        entry.setConfigType(this.configType);
        this.subSections.add(entry);
        return entry;
    }

    final void setConfigType(ModConfig.Type type) {
        this.configType = type;
        this.subSections.forEach(section -> section.setConfigType(type));
    }

    @Override
    public final void accept(ForgeConfigSpec.Builder builder) {
        this.createEntries(builder);
        for (ConfigEntry section : this.subSections) {
            List splitPath = CommonConfig.DOT_SPLITTER.splitToList((CharSequence)section.getPath());
            builder.push(splitPath);
            section.accept(builder);
            builder.pop(splitPath.size());
        }
    }

    protected String translationKey(String key) {
        return String.format("config.%s.%s.%s", this.configType.extension(), this.getFullPath(), key);
    }

    public abstract void createEntries(ForgeConfigSpec.Builder var1);

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.subPath.isEmpty() ? this.getPath() : String.format("%s.%s", this.subPath, this.getPath());
    }
}

