/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.AmuletEnchantmentEntry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class AmuletEnchantmentRegistry
extends ConfigDataAdapter<AmuletEnchantmentEntry> {
    private static final Random rand = new Random();
    public static final AmuletEnchantmentRegistry INSTANCE = new AmuletEnchantmentRegistry();

    private AmuletEnchantmentRegistry() {
    }

    @Override
    public List<AmuletEnchantmentEntry> getDefaultValues() {
        LinkedList<AmuletEnchantmentEntry> enchantments = new LinkedList<AmuletEnchantmentEntry>();
        for (Enchantment e : ForgeRegistries.ENCHANTMENTS.getValues()) {
            if (e.func_190936_d()) continue;
            enchantments.add(new AmuletEnchantmentEntry(e, e.func_77324_c().func_185270_a()));
        }
        return enchantments;
    }

    @Nullable
    public static Enchantment getRandomEnchant() {
        List cfgValues = INSTANCE.getConfiguredValues();
        if (cfgValues.isEmpty()) {
            return null;
        }
        AmuletEnchantmentEntry entry = MiscUtils.getWeightedRandomEntry(cfgValues, rand, AmuletEnchantmentEntry::getWeight);
        if (entry == null) {
            return null;
        }
        return entry.getEnchantment();
    }

    public static boolean canBeInfluenced(Enchantment ench) {
        for (AmuletEnchantmentEntry e : INSTANCE.getConfiguredValues()) {
            if (!e.getEnchantment().equals(ench)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSectionName() {
        return "amulet_enchantments";
    }

    @Override
    public String getCommentDescription() {
        return "Defines a whitelist of which enchantments can be rolled and buffed by the enchantment-amulet. The higher the weight, the more likely that roll is selected.Format: <enchantment-registry-name>;<weight>";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey("data");
    }

    @Override
    public Predicate<Object> getValidator() {
        return obj -> obj instanceof String && AmuletEnchantmentEntry.deserialize((String)obj) != null;
    }

    @Override
    @Nullable
    public AmuletEnchantmentEntry deserialize(String string) throws IllegalArgumentException {
        return AmuletEnchantmentEntry.deserialize(string);
    }
}

