/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataAdapter;
import hellfirepvp.astralsorcery.common.data.config.registry.sets.OreItemRarityEntry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.tags.Tag;
import net.minecraftforge.common.Tags;

public class OreItemRarityRegistry
extends ConfigDataAdapter<OreItemRarityEntry> {
    public static final OreItemRarityRegistry VOID_TRASH_REWARD = new OreItemRarityRegistry("perk_void_trash_ore");
    private final String fileName;

    private OreItemRarityRegistry(String fileName) {
        this.fileName = fileName;
    }

    @Nullable
    public Item getRandomItem(Random rand) {
        List entries = this.getConfiguredValues();
        HashSet<OreItemRarityEntry> visitedEntires = new HashSet<OreItemRarityEntry>();
        while (visitedEntires.size() < entries.size()) {
            OreItemRarityEntry entry = MiscUtils.getWeightedRandomEntry(entries.stream().filter(value -> !visitedEntires.contains(value)).collect(Collectors.toList()), rand, OreItemRarityEntry::getWeight);
            if (entry != null) {
                visitedEntires.add(entry);
                Item i = entry.getRandomItem(rand);
                if (i == null) continue;
                return i;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<OreItemRarityEntry> getDefaultValues() {
        return Lists.newArrayList((Object[])new OreItemRarityEntry[]{new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_COAL, 5200), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_IRON, 2500), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_GOLD, 550), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_LAPIS, 360), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_REDSTONE, 700), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_DIAMOND, 120), new OreItemRarityEntry((Tag<Item>)Tags.Items.ORES_EMERALD, 100)});
    }

    @Override
    public String getSectionName() {
        return this.fileName;
    }

    @Override
    public String getCommentDescription() {
        return "Format: '<tagName>;<integerWeight>' Defines random-weighted ore-selection data. Define item-tags to select from here with associated weight. Specific mods can be blacklisted in the general AstralSorcery config in 'modidOreBlacklist'.";
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey("data");
    }

    @Override
    public Predicate<Object> getValidator() {
        return obj -> obj instanceof String;
    }

    @Override
    @Nullable
    public OreItemRarityEntry deserialize(String string) throws IllegalArgumentException {
        return OreItemRarityEntry.deserialize(string);
    }
}

