/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PlayerProgress {
    private List<ResourceLocation> knownConstellations = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> seenConstellations = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> storedConstellationPapers = new ArrayList<ResourceLocation>();
    private IMajorConstellation attunedConstellation = null;
    private boolean wasOnceAttuned = false;
    private List<ResearchProgression> researchProgression = new ArrayList<ResearchProgression>();
    private ProgressionTier tierReached = ProgressionTier.DISCOVERY;
    private List<String> freePointTokens = Lists.newArrayList();
    private Set<AbstractPerk> appliedPerks = new HashSet<AbstractPerk>();
    private Map<AbstractPerk, CompoundNBT> appliedPerkData = new HashMap<AbstractPerk, CompoundNBT>();
    private List<AbstractPerk> sealedPerks = new ArrayList<AbstractPerk>();
    private double perkExp = 0.0;
    private boolean tomeReceived = false;
    private boolean usePerkAbilities = true;

    public void load(CompoundNBT compound) {
        ResourceLocation s;
        int i;
        ListNBT list;
        this.knownConstellations.clear();
        this.seenConstellations.clear();
        this.researchProgression.clear();
        this.storedConstellationPapers.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.wasOnceAttuned = false;
        this.appliedPerks.clear();
        this.appliedPerkData.clear();
        this.sealedPerks.clear();
        this.freePointTokens.clear();
        this.perkExp = 0.0;
        this.tomeReceived = false;
        this.usePerkAbilities = true;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.size(); ++i) {
                this.seenConstellations.add(new ResourceLocation(list.func_150307_f(i)));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.size(); ++i) {
                s = new ResourceLocation(list.func_150307_f(i));
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("storedConstellationPapers")) {
            list = compound.func_150295_c("storedConstellationPapers", 8);
            for (i = 0; i < list.size(); ++i) {
                s = new ResourceLocation(list.func_150307_f(i));
                this.storedConstellationPapers.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("attuned")) {
            String cst = compound.func_74779_i("attuned");
            IConstellation c = ConstellationRegistry.getConstellation(new ResourceLocation(cst));
            if (!(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("Failed to load attuned Constellation: " + cst + " - constellation doesn't exist or isn't major.");
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        long perkTreeLevel = compound.func_74763_f("perkTreeVersion");
        if (PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).map(v -> !v.equals(perkTreeLevel)).orElse(true).booleanValue()) {
            RootPerk root;
            AstralSorcery.log.info("Clearing perk-tree because the player's skill-tree version was outdated!");
            if (this.attunedConstellation != null && (root = PerkTree.PERK_TREE.getRootPerk(LogicalSide.SERVER, this.attunedConstellation)) != null) {
                CompoundNBT data = new CompoundNBT();
                root.onUnlockPerkServer(null, this, data);
                this.appliedPerks.add(root);
                this.appliedPerkData.put(root, data);
            }
        } else {
            String perkRegName;
            CompoundNBT tag;
            int i2;
            ListNBT list2;
            if (compound.func_74764_b("perks")) {
                list2 = compound.func_150295_c("perks", 10);
                for (i2 = 0; i2 < list2.size(); ++i2) {
                    tag = list2.func_150305_b(i2);
                    perkRegName = tag.func_74779_i("perkName");
                    CompoundNBT data = tag.func_74775_l("perkData");
                    PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, new ResourceLocation(perkRegName)).ifPresent(perk -> {
                        this.appliedPerks.add((AbstractPerk)perk);
                        this.appliedPerkData.put((AbstractPerk)perk, data);
                    });
                }
            }
            if (compound.func_74764_b("sealedPerks")) {
                list2 = compound.func_150295_c("sealedPerks", 10);
                for (i2 = 0; i2 < list2.size(); ++i2) {
                    tag = list2.func_150305_b(i2);
                    perkRegName = tag.func_74779_i("perkName");
                    PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, new ResourceLocation(perkRegName)).ifPresent(perk -> this.sealedPerks.add((AbstractPerk)perk));
                }
            }
            if (compound.func_74764_b("pointTokens")) {
                list2 = compound.func_150295_c("pointTokens", 8);
                for (i2 = 0; i2 < list2.size(); ++i2) {
                    this.freePointTokens.add(list2.func_150307_f(i2));
                }
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = MiscUtils.getEnumEntry(ProgressionTier.class, tierOrdinal);
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                this.researchProgression.add(ResearchProgression.values()[resOrdinal]);
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
        if (compound.func_74764_b("perkExp")) {
            this.perkExp = compound.func_74769_h("perkExp");
        }
        this.tomeReceived = !compound.func_74764_b("bookReceived") ? true : compound.func_74767_n("bookReceived");
        if (compound.func_74764_b("usePerkAbilities")) {
            this.usePerkAbilities = compound.func_74767_n("usePerkAbilities");
        }
    }

    public void store(CompoundNBT cmp) {
        CompoundNBT tag;
        ListNBT known = new ListNBT();
        for (ResourceLocation resourceLocation : this.knownConstellations) {
            known.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT seen = new ListNBT();
        for (ResourceLocation resourceLocation : this.seenConstellations) {
            seen.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT listNBT = new ListNBT();
        for (ResourceLocation resourceLocation : this.storedConstellationPapers) {
            listNBT.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        cmp.func_218657_a("constellations", (INBT)known);
        cmp.func_218657_a("seenConstellations", (INBT)seen);
        cmp.func_218657_a("storedConstellationPapers", (INBT)listNBT);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        ListNBT listNBT2 = new ListNBT();
        for (String s : this.freePointTokens) {
            listNBT2.add((Object)StringNBT.func_229705_a_((String)s));
        }
        cmp.func_218657_a("pointTokens", (INBT)listNBT2);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            nArray[i] = this.researchProgression.get(i).ordinal();
        }
        cmp.func_74783_a("research", nArray);
        if (this.attunedConstellation != null) {
            cmp.func_74778_a("attuned", this.attunedConstellation.getRegistryName().toString());
        }
        known = new ListNBT();
        for (Map.Entry<AbstractPerk, CompoundNBT> entry : this.appliedPerkData.entrySet()) {
            tag = new CompoundNBT();
            tag.func_74778_a("perkName", entry.getKey().getRegistryName().toString());
            tag.func_218657_a("perkData", (INBT)entry.getValue());
            known.add((Object)tag);
        }
        cmp.func_218657_a("perks", (INBT)known);
        known = new ListNBT();
        for (AbstractPerk perk : this.sealedPerks) {
            tag = new CompoundNBT();
            tag.func_74778_a("perkName", perk.getRegistryName().toString());
            known.add((Object)tag);
        }
        cmp.func_218657_a("sealedPerks", (INBT)known);
        PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).ifPresent(version -> cmp.func_74772_a("perkTreeVersion", version.longValue()));
        cmp.func_74780_a("perkExp", this.perkExp);
        cmp.func_74757_a("bookReceived", this.tomeReceived);
        cmp.func_74757_a("usePerkAbilities", this.usePerkAbilities);
    }

    public void storeKnowledge(CompoundNBT cmp) {
        ListNBT list = new ListNBT();
        for (ResourceLocation resourceLocation : this.knownConstellations) {
            list.add((Object)StringNBT.func_229705_a_((String)resourceLocation.toString()));
        }
        ListNBT l = new ListNBT();
        for (ResourceLocation s : this.seenConstellations) {
            l.add((Object)StringNBT.func_229705_a_((String)s.toString()));
        }
        cmp.func_218657_a("constellations", (INBT)list);
        cmp.func_218657_a("seenConstellations", (INBT)l);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            nArray[i] = this.researchProgression.get(i).ordinal();
        }
        cmp.func_74783_a("research", nArray);
    }

    public void loadKnowledge(CompoundNBT compound) {
        int i;
        ListNBT list;
        this.knownConstellations.clear();
        this.researchProgression.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.wasOnceAttuned = false;
        this.appliedPerks.clear();
        this.appliedPerkData.clear();
        this.sealedPerks.clear();
        this.freePointTokens.clear();
        this.perkExp = 0.0;
        this.tomeReceived = false;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.size(); ++i) {
                this.seenConstellations.add(new ResourceLocation(list.func_150307_f(i)));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.size(); ++i) {
                ResourceLocation s = new ResourceLocation(list.func_150307_f(i));
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = MiscUtils.getEnumEntry(ProgressionTier.class, tierOrdinal);
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                this.researchProgression.add(ResearchProgression.values()[resOrdinal]);
            }
        }
        if (compound.func_74764_b("pointTokens")) {
            ListNBT list2 = compound.func_150295_c("pointTokens", 8);
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                this.freePointTokens.add(list2.func_150307_f(i2));
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
    }

    public boolean isValid() {
        return true;
    }

    protected boolean forceGainResearch(ResearchProgression progression) {
        if (!this.researchProgression.contains((Object)progression)) {
            this.researchProgression.add(progression);
            return true;
        }
        return false;
    }

    protected void setAttunedConstellation(IMajorConstellation constellation) {
        this.attunedConstellation = constellation;
        this.wasOnceAttuned = true;
    }

    public Collection<AbstractPerk> getAppliedPerks() {
        return this.appliedPerks == null ? Lists.newArrayList() : Collections.unmodifiableCollection(this.appliedPerks);
    }

    public List<AbstractPerk> getSealedPerks() {
        return this.sealedPerks == null ? Lists.newArrayList() : Collections.unmodifiableList(this.sealedPerks);
    }

    public Map<AbstractPerk, CompoundNBT> getUnlockedPerkData() {
        return this.appliedPerkData == null ? Maps.newHashMap() : Collections.unmodifiableMap(this.appliedPerkData);
    }

    @Nullable
    public CompoundNBT getPerkData(AbstractPerk perk) {
        CompoundNBT tag = this.appliedPerkData.get(perk);
        return tag == null ? null : tag.func_74737_b();
    }

    public boolean hasPerkEffect(Predicate<AbstractPerk> perkMatch) {
        AbstractPerk perk = MiscUtils.iterativeSearch(this.appliedPerks, perkMatch);
        return perk != null && this.hasPerkEffect(perk);
    }

    public boolean hasPerkEffect(AbstractPerk perk) {
        return this.hasPerkUnlocked(perk) && !this.isPerkSealed(perk);
    }

    public boolean hasPerkUnlocked(AbstractPerk perk) {
        return this.appliedPerks.contains(perk);
    }

    public boolean isPerkSealed(AbstractPerk perk) {
        return this.sealedPerks.contains(perk);
    }

    public void applyPerk(AbstractPerk perk, CompoundNBT data) {
        this.appliedPerks.add(perk);
        this.appliedPerkData.put(perk, data);
    }

    boolean removePerk(AbstractPerk perk) {
        return this.appliedPerks.remove(perk) && (!this.sealedPerks.contains(perk) || this.sealedPerks.remove(perk));
    }

    boolean removePerkData(AbstractPerk perk) {
        return this.appliedPerkData.remove(perk) != null;
    }

    protected boolean canSealPerk(AbstractPerk perk) {
        return !this.sealedPerks.contains(perk) && this.hasPerkUnlocked(perk);
    }

    protected boolean sealPerk(AbstractPerk perk) {
        if (!this.canSealPerk(perk)) {
            return false;
        }
        return this.sealedPerks.add(perk);
    }

    protected boolean breakSeal(AbstractPerk perk) {
        if (!this.sealedPerks.contains(perk) || !this.hasPerkUnlocked(perk)) {
            return false;
        }
        return this.sealedPerks.remove(perk);
    }

    public List<ResearchProgression> getResearchProgression() {
        this.researchProgression.removeIf(Objects::isNull);
        return Lists.newLinkedList(this.researchProgression);
    }

    public ProgressionTier getTierReached() {
        return this.tierReached;
    }

    public IMajorConstellation getAttunedConstellation() {
        return this.attunedConstellation;
    }

    public boolean wasOnceAttuned() {
        return this.wasOnceAttuned;
    }

    protected void setAttunedBefore(boolean attuned) {
        this.wasOnceAttuned = attuned;
    }

    public boolean didReceiveTome() {
        return this.tomeReceived;
    }

    protected void setTomeReceived() {
        this.tomeReceived = true;
    }

    public boolean doPerkAbilities() {
        return this.usePerkAbilities;
    }

    protected void setUsePerkAbilities(boolean usePerkAbilities) {
        this.usePerkAbilities = usePerkAbilities;
    }

    protected boolean grantFreeAllocationPoint(String freePointToken) {
        if (this.freePointTokens.contains(freePointToken)) {
            return false;
        }
        this.freePointTokens.add(freePointToken);
        return true;
    }

    protected boolean tryRevokeAllocationPoint(String token) {
        return this.freePointTokens.remove(token);
    }

    public List<String> getFreePointTokens() {
        return Collections.unmodifiableList(this.freePointTokens);
    }

    public int getAvailablePerkPoints(PlayerEntity player, LogicalSide side) {
        int allocatedPerks = this.appliedPerks.size() - 1;
        int allocationLevels = PerkLevelManager.getLevel(this.getPerkExp(), player, side);
        return allocationLevels + this.freePointTokens.size() - allocatedPerks;
    }

    public boolean hasFreeAllocationPoint(PlayerEntity player, LogicalSide side) {
        return this.getAvailablePerkPoints(player, side) > 0;
    }

    public double getPerkExp() {
        return this.perkExp;
    }

    public int getPerkLevel(PlayerEntity player, LogicalSide side) {
        return PerkLevelManager.getLevel(this.getPerkExp(), player, side);
    }

    public float getPercentToNextLevel(PlayerEntity player, LogicalSide side) {
        return PerkLevelManager.getNextLevelPercent(this.getPerkExp(), player, side);
    }

    protected void modifyExp(double exp, PlayerEntity player, LogicalSide side) {
        int currLevel = PerkLevelManager.getLevel(this.getPerkExp(), player, side);
        if (exp >= 0.0 && currLevel >= PerkLevelManager.getLevelCap(side, player)) {
            return;
        }
        long expThisLevel = PerkLevelManager.getExpForLevel(currLevel, player, side);
        long expNextLevel = PerkLevelManager.getExpForLevel(currLevel + 1, player, side);
        long cap = MathHelper.func_76124_d((double)((float)(expNextLevel - expThisLevel) * 0.08f));
        if (exp > (double)cap) {
            exp = cap;
        }
        this.perkExp = Math.max(this.perkExp + exp, 0.0);
    }

    protected void setExp(double exp) {
        this.perkExp = Math.max(exp, 0.0);
    }

    protected boolean stepTier() {
        if (this.getTierReached().hasNextTier()) {
            this.setTierReached(ProgressionTier.values()[this.getTierReached().ordinal() + 1]);
            return true;
        }
        return false;
    }

    protected void setTierReached(ProgressionTier tier) {
        this.tierReached = tier;
    }

    public List<ResourceLocation> getKnownConstellations() {
        return this.knownConstellations;
    }

    public List<ResourceLocation> getSeenConstellations() {
        return this.seenConstellations;
    }

    public List<ResourceLocation> getStoredConstellationPapers() {
        return this.storedConstellationPapers;
    }

    public boolean hasSeenConstellation(IConstellation constellation) {
        return this.hasSeenConstellation(constellation.getRegistryName());
    }

    public boolean hasSeenConstellation(ResourceLocation constellation) {
        return this.seenConstellations.contains(constellation);
    }

    public boolean hasConstellationDiscovered(IConstellation constellation) {
        return this.hasConstellationDiscovered(constellation.getRegistryName());
    }

    public boolean hasConstellationDiscovered(ResourceLocation constellation) {
        return this.knownConstellations.contains(constellation);
    }

    protected void discoverConstellation(ResourceLocation name) {
        this.memorizeConstellation(name);
        if (!this.knownConstellations.contains(name)) {
            this.knownConstellations.add(name);
        }
    }

    protected void memorizeConstellation(ResourceLocation name) {
        if (!this.seenConstellations.contains(name)) {
            this.seenConstellations.add(name);
        }
    }

    protected void setStoredConstellationPapers(List<ResourceLocation> names) {
        this.storedConstellationPapers.clear();
        this.storedConstellationPapers.addAll(names);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void receive(PktSyncKnowledge message) {
        this.knownConstellations = message.knownConstellations;
        this.seenConstellations = message.seenConstellations;
        this.storedConstellationPapers = message.storedConstellationPapers;
        this.researchProgression = message.researchProgression;
        this.tierReached = MiscUtils.getEnumEntry(ProgressionTier.class, message.progressTier);
        this.attunedConstellation = message.attunedConstellation;
        this.wasOnceAttuned = message.wasOnceAttuned;
        this.freePointTokens = message.freePointTokens;
        this.appliedPerks = message.usedPerks.keySet().stream().map(perkKey -> PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, (ResourceLocation)perkKey)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.appliedPerkData = MapStream.of(message.usedPerks).mapKey(perkKey -> PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, (ResourceLocation)perkKey)).filterKey(Optional::isPresent).mapKey(Optional::get).toMap();
        this.sealedPerks = message.sealedPerks.stream().map(perkKey -> PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, (ResourceLocation)perkKey)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.perkExp = message.perkExp;
    }

    protected PlayerProgress copy() {
        PlayerProgress copy = new PlayerProgress();
        CompoundNBT saveData = new CompoundNBT();
        this.store(saveData);
        copy.load(saveData);
        return copy;
    }

    public void acceptMergeFrom(PlayerProgress toMergeFrom) {
        for (ResourceLocation seen : toMergeFrom.seenConstellations) {
            this.memorizeConstellation(seen);
        }
        for (ResourceLocation known : toMergeFrom.knownConstellations) {
            this.discoverConstellation(known);
        }
        if (toMergeFrom.wasOnceAttuned) {
            this.wasOnceAttuned = true;
        }
        if (toMergeFrom.tierReached.isThisLaterOrEqual(this.tierReached)) {
            this.tierReached = toMergeFrom.tierReached;
        }
        for (ResearchProgression prog : toMergeFrom.researchProgression) {
            this.forceGainResearch(prog);
        }
    }
}

