/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class ClientLightBlockEndpoints
extends ClientData<ClientLightBlockEndpoints> {
    private Map<DimensionType, Set<BlockPos>> clientPositions = new HashMap<DimensionType, Set<BlockPos>>();

    public boolean doesPositionReceiveStarlightClient(IWorld world, BlockPos pos) {
        return this.clientPositions.getOrDefault(world.func_201675_m().func_186058_p(), Collections.emptySet()).contains(pos);
    }

    @Override
    public void clear(DimensionType dimType) {
        this.clientPositions.remove(dimType);
    }

    @Override
    public void clearClient() {
        this.clientPositions.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientLightBlockEndpoints> {
        @Override
        public void readFromIncomingFullSync(ClientLightBlockEndpoints data, CompoundNBT compound) {
            data.clientPositions.clear();
            for (String dimTypeKey : compound.func_150296_c()) {
                DimensionType type = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimTypeKey)).orElse(null);
                if (type == null) continue;
                HashSet<BlockPos> positions = new HashSet<BlockPos>();
                ListNBT list = compound.func_150295_c(dimTypeKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("pos"));
                    positions.add(pos);
                }
                data.clientPositions.put(type, positions);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientLightBlockEndpoints data, CompoundNBT compound) {
            HashSet<String> clearedDimensions = new HashSet<String>();
            for (INBT dimKeyNBT : compound.func_150295_c("clear", 8)) {
                String dimKey = dimKeyNBT.func_150285_a_();
                DimensionType type = DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimKey)).orElse(null);
                if (type != null) {
                    data.clientPositions.remove(type);
                }
                clearedDimensions.add(dimKey);
            }
            for (String dimTypeKey : compound.func_150296_c()) {
                DimensionType type;
                if (clearedDimensions.contains(dimTypeKey) || (type = (DimensionType)DimensionManager.getRegistry().func_218349_b(new ResourceLocation(dimTypeKey)).orElse(null)) == null) continue;
                Set positions = data.clientPositions.computeIfAbsent(type, k -> new HashSet());
                ListNBT list = compound.func_150295_c(dimTypeKey, 10);
                for (INBT iTag : list) {
                    CompoundNBT tag = (CompoundNBT)iTag;
                    BlockPos pos = BlockPos.func_218283_e((long)tag.func_74763_f("pos"));
                    boolean addNew = tag.func_74767_n("add");
                    if (addNew) {
                        positions.add(pos);
                        continue;
                    }
                    positions.remove(pos);
                }
            }
        }
    }
}

