/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.server;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.base.patreon.entity.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractData;
import hellfirepvp.astralsorcery.common.data.sync.base.AbstractDataProvider;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientPatreonFlares;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;

public class DataPatreonFlares
extends AbstractData {
    private Map<UUID, Set<PatreonPartialEntity>> entitiesServer = new HashMap<UUID, Set<PatreonPartialEntity>>();
    private Set<UUID> flarePlayerUpdates = new HashSet<UUID>();
    private Set<UUID> flareRemovals = new HashSet<UUID>();

    private DataPatreonFlares(ResourceLocation key) {
        super(key);
    }

    @Nullable
    public PatreonPartialEntity createEntity(PlayerEntity player, PatreonEffect value) {
        UUID owner = player.func_110124_au();
        PatreonPartialEntity entity = value.createEntity(owner);
        if (entity == null) {
            return null;
        }
        entity.placeNear(player);
        this.entitiesServer.computeIfAbsent(owner, o -> new HashSet()).add(entity);
        this.flareRemovals.remove(owner);
        this.flarePlayerUpdates.add(owner);
        this.markDirty();
        return entity;
    }

    public void updateEntitiesOf(UUID playerUUID) {
        this.flareRemovals.remove(playerUUID);
        this.flarePlayerUpdates.add(playerUUID);
        this.markDirty();
    }

    public void removeEntities(UUID playerUUID) {
        this.flarePlayerUpdates.remove(playerUUID);
        this.flareRemovals.add(playerUUID);
        this.markDirty();
        this.entitiesServer.getOrDefault(playerUUID, Collections.emptySet()).forEach(p -> p.setRemoved(true));
    }

    @Nonnull
    public Collection<UUID> getOwners() {
        return this.entitiesServer.keySet();
    }

    @Nonnull
    public Collection<PatreonPartialEntity> getEntities(UUID playerUUID) {
        return this.entitiesServer.getOrDefault(playerUUID, Collections.emptySet());
    }

    @Nonnull
    public Collection<Collection<PatreonPartialEntity>> getEntities() {
        return new ArrayList<Collection<PatreonPartialEntity>>(this.entitiesServer.values());
    }

    @Override
    public void clear(DimensionType dimType) {
    }

    @Override
    public void clearServer() {
        this.entitiesServer.clear();
        this.flarePlayerUpdates.clear();
        this.flareRemovals.clear();
    }

    @Override
    public void writeAllDataToPacket(CompoundNBT compound) {
        ListNBT entities = new ListNBT();
        for (UUID playerUUID : this.entitiesServer.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("playerUUID", playerUUID);
            ListNBT entityList = new ListNBT();
            for (PatreonPartialEntity entity : this.entitiesServer.get(playerUUID)) {
                CompoundNBT entityNBT = new CompoundNBT();
                entityNBT.func_186854_a("id", entity.getEffectUUID());
                CompoundNBT data = new CompoundNBT();
                entity.writeToNBT(data);
                entityNBT.func_218657_a("data", (INBT)data);
                entityList.add((Object)entityNBT);
            }
            tag.func_218657_a("entityList", (INBT)entityList);
            entities.add((Object)tag);
        }
        compound.func_218657_a("entities", (INBT)entities);
    }

    @Override
    public void writeDiffDataToPacket(CompoundNBT compound) {
        ListNBT listUpdates = new ListNBT();
        for (UUID playerUUID : this.flarePlayerUpdates) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("playerUUID", playerUUID);
            ListNBT entityList = new ListNBT();
            for (PatreonPartialEntity entity : this.entitiesServer.get(playerUUID)) {
                CompoundNBT entityNBT = new CompoundNBT();
                entityNBT.func_186854_a("id", entity.getEffectUUID());
                CompoundNBT data = new CompoundNBT();
                entity.writeToNBT(data);
                entityNBT.func_218657_a("data", (INBT)data);
                entityList.add((Object)entityNBT);
            }
            tag.func_218657_a("entityList", (INBT)entityList);
            listUpdates.add((Object)tag);
        }
        ListNBT listRemovals = new ListNBT();
        for (UUID playerUUID : this.flareRemovals) {
            CompoundNBT playerTag = new CompoundNBT();
            playerTag.func_186854_a("playerUUID", playerUUID);
            listRemovals.add((Object)playerTag);
        }
        compound.func_218657_a("updates", (INBT)listUpdates);
        compound.func_218657_a("removals", (INBT)listRemovals);
        this.flarePlayerUpdates.clear();
        this.flareRemovals.clear();
    }

    public static class Provider
    extends AbstractDataProvider<DataPatreonFlares, ClientPatreonFlares> {
        public Provider(ResourceLocation key) {
            super(key);
        }

        @Override
        public DataPatreonFlares provideServerData() {
            return new DataPatreonFlares(this.getKey());
        }

        @Override
        public ClientPatreonFlares provideClientData() {
            return new ClientPatreonFlares();
        }

        @Override
        public ClientDataReader<ClientPatreonFlares> createReader() {
            return new ClientPatreonFlares.Reader();
        }
    }
}

