/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import hellfirepvp.astralsorcery.common.util.log.LogUtil;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.GlobalWorldData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GatewayCache
extends GlobalWorldData {
    private List<GatewayNode> gatewayPositions = new LinkedList<GatewayNode>();

    public GatewayCache(WorldCacheDomain.SaveKey<?> key) {
        super(key);
    }

    public List<GatewayNode> getGatewayPositions() {
        return new ArrayList<GatewayNode>(this.gatewayPositions);
    }

    public void offerPosition(World world, BlockPos pos, @Nonnull String display) {
        TileEntity te = world.func_175625_s(pos);
    }

    public void removePosition(World world, BlockPos pos) {
        if (this.gatewayPositions.remove(pos)) {
            this.markDirty();
            LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Removed gateway node at: dim=" + world.func_201675_m().func_186058_p().func_186068_a() + ", " + pos.toString());
        }
    }

    public void updateTick(World world) {
    }

    public void onLoad(IWorld world) {
        super.onLoad(world);
        LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Checking GatewayCache integrity for dimension " + world.func_201675_m().func_186058_p().func_186068_a());
        long msStart = System.currentTimeMillis();
        Iterator<GatewayNode> iterator = this.gatewayPositions.iterator();
        while (iterator.hasNext()) {
            GatewayNode node = iterator.next();
            Object gateway = null;
            if (gateway != null) continue;
            iterator.remove();
            LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "Invalid entry: " + (Object)((Object)node) + " - no gateway tileentity found there!");
        }
        LogUtil.info(LogCategory.GATEWAY_CACHE, () -> "GatewayCache checked and fully loaded in " + (System.currentTimeMillis() - msStart) + "ms! Collected and checked " + this.gatewayPositions.size() + " gateway nodes!");
    }

    public void writeToNBT(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (GatewayNode node : this.gatewayPositions) {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(node, tag);
            tag.func_74778_a("display", node.display);
            list.add((Object)tag);
        }
        compound.func_218657_a("posList", (INBT)list);
    }

    public void readFromNBT(CompoundNBT compound) {
        ListNBT list = compound.func_150295_c("posList", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(tag);
            String display = tag.func_74779_i("display");
            GatewayNode node = new GatewayNode(pos, display);
            this.gatewayPositions.add(node);
        }
    }

    private static /* synthetic */ String lambda$offerPosition$0(World world, BlockPos pos) {
        return "Added new gateway node at: dim=" + world.func_201675_m().func_186058_p().func_186068_a() + ", " + pos.toString();
    }

    public static class GatewayNode
    extends BlockPos {
        private final String display;

        public GatewayNode(BlockPos pos, String display) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.display = display;
        }

        public String getDisplayName() {
            return this.display;
        }

        public boolean equals(Object pos) {
            return super.equals(pos);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

