/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.config.entry.LightNetworkConfig;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightTransmissionHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockStateHelper;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.SectionWorldData;
import hellfirepvp.observerlib.common.data.base.WorldSection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class LightNetworkBuffer
extends SectionWorldData<ChunkNetworkData> {
    private Map<BlockPos, IIndependentStarlightSource> starlightSources = new HashMap<BlockPos, IIndependentStarlightSource>();
    private Collection<Tuple<BlockPos, IIndependentStarlightSource>> cachedSourceTuples = null;
    private Set<BlockPos> queueRemoval = new HashSet<BlockPos>();

    public LightNetworkBuffer(WorldCacheDomain.SaveKey<?> key) {
        super(key, 4);
    }

    public WorldNetworkHandler getNetworkHandler(World world) {
        return new WorldNetworkHandler(this, world);
    }

    protected ChunkNetworkData createNewSection(int sectionX, int sectionZ) {
        return new ChunkNetworkData(sectionX, sectionZ);
    }

    public void updateTick(World world) {
        this.cleanupQueuedChunks();
        TransmissionWorldHandler handle = StarlightTransmissionHandler.getInstance().getWorldHandler((IWorld)world);
        Iterator<Map.Entry<BlockPos, IIndependentStarlightSource>> iterator = this.starlightSources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, IIndependentStarlightSource> entry = iterator.next();
            BlockPos pos = entry.getKey();
            IIndependentStarlightSource source = entry.getValue();
            MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                TileEntity te = world.func_175625_s(pos);
                if (te != null) {
                    if (te instanceof IStarlightSource) {
                        if (((IStarlightSource)te).needsToRefreshNetworkChain()) {
                            if (handle != null) {
                                handle.breakSourceNetwork(source);
                            }
                            ((IStarlightSource)te).markChainRebuilt();
                        }
                    } else {
                        ChunkNetworkData data;
                        BlockState actual = world.func_180495_p(pos);
                        AstralSorcery.log.warn("Cached source at " + pos + " but didn't find the TileEntity!");
                        AstralSorcery.log.warn("Purging cache entry and removing erroneous block!");
                        AstralSorcery.log.warn("Block that gets purged: " + BlockStateHelper.serialize(actual));
                        iterator.remove();
                        if (world.func_175656_a(pos, actual.func_204520_s().func_206883_i()) && (data = (ChunkNetworkData)this.getSection((Vec3i)pos)) != null) {
                            data.removeSourceTile(pos);
                        }
                    }
                }
            });
        }
    }

    public void onLoad(IWorld world) {
        super.onLoad(world);
        if (((Boolean)LightNetworkConfig.CONFIG.performNetworkIntegrityCheck.get()).booleanValue()) {
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Performing StarlightNetwork integrity check for world " + world.func_201675_m().func_186058_p().func_186068_a());
            LinkedList<IPrismTransmissionNode> invalidRemoval = new LinkedList<IPrismTransmissionNode>();
            for (ChunkNetworkData data : this.getSections()) {
                for (ChunkSectionNetworkData secData : data.sections.values()) {
                    for (IPrismTransmissionNode node : secData.getAllTransmissionNodes()) {
                        TileEntity te = world.func_175625_s(node.getLocationPos());
                        if (!(te instanceof IStarlightTransmission)) {
                            invalidRemoval.add(node);
                            continue;
                        }
                        IStarlightTransmission ism = (IStarlightTransmission)te;
                        Object newNode = ism.provideTransmissionNode(node.getLocationPos());
                        if (!node.getClass().isAssignableFrom(newNode.getClass())) {
                            invalidRemoval.add(node);
                            continue;
                        }
                        if (node.needsUpdate()) {
                            StarlightUpdateHandler.getInstance().addNode(world, node);
                        }
                        node.postLoad(world);
                    }
                }
            }
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Performed StarlightNetwork integrity check. Found " + invalidRemoval.size() + " invalid transmission nodes.");
            for (IPrismTransmissionNode node : invalidRemoval) {
                this.removeTransmission(node.getLocationPos());
            }
            AstralSorcery.log.info("[LightNetworkIntegrityCheck] Removed invalid transmission nodes from the network.");
        } else {
            for (ChunkNetworkData data : this.getSections()) {
                for (ChunkSectionNetworkData secData : data.sections.values()) {
                    for (IPrismTransmissionNode node : secData.getAllTransmissionNodes()) {
                        if (node.needsUpdate()) {
                            StarlightUpdateHandler.getInstance().addNode(world, node);
                        }
                        node.postLoad(world);
                    }
                }
            }
        }
    }

    private void cleanupQueuedChunks() {
        for (BlockPos pos : this.queueRemoval) {
            ChunkNetworkData data = (ChunkNetworkData)this.getSection((Vec3i)pos);
            if (data == null || !data.isEmpty()) continue;
            this.removeSection(data);
        }
        this.queueRemoval.clear();
    }

    @Nullable
    public ChunkSectionNetworkData getSectionData(BlockPos pos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getSection((Vec3i)pos);
        if (data == null) {
            return null;
        }
        return data.getSection(pos.func_177956_o() >> 4);
    }

    @Nullable
    public IIndependentStarlightSource getSource(BlockPos at) {
        return this.starlightSources.get(at);
    }

    public Collection<Tuple<BlockPos, IIndependentStarlightSource>> getAllSources() {
        if (this.cachedSourceTuples == null) {
            LinkedList<Tuple> cache = new LinkedList<Tuple>();
            for (Map.Entry<BlockPos, IIndependentStarlightSource> entry : this.starlightSources.entrySet()) {
                cache.add(new Tuple((Object)entry.getKey(), (Object)entry.getValue()));
            }
            this.cachedSourceTuples = Collections.unmodifiableCollection(cache);
        }
        return this.cachedSourceTuples;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.starlightSources.clear();
        this.cachedSourceTuples = null;
        if (nbt.func_74764_b("sources")) {
            ListNBT list = nbt.func_150295_c("sources", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT sourcePos = list.func_150305_b(i);
                BlockPos at = NBTHelper.readBlockPosFromNBT(sourcePos);
                CompoundNBT comp = sourcePos.func_74775_l("source");
                ResourceLocation identifier = new ResourceLocation(comp.func_74779_i("sTypeId"));
                SourceClassRegistry.SourceProvider provider = SourceClassRegistry.getProvider(identifier);
                if (provider == null) {
                    AstralSorcery.log.warn("Couldn't load source tile at " + at + " - invalid identifier: " + identifier);
                    continue;
                }
                IIndependentStarlightSource source = provider.provideEmptySource();
                source.readFromNBT(comp);
                this.starlightSources.put(at, source);
            }
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
        this.cleanupQueuedChunks();
        ListNBT sourceList = new ListNBT();
        for (BlockPos pos : this.starlightSources.keySet()) {
            CompoundNBT sourceTag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(pos, sourceTag);
            CompoundNBT source = new CompoundNBT();
            IIndependentStarlightSource sourceNode = this.starlightSources.get(pos);
            try {
                sourceNode.writeToNBT(source);
            }
            catch (Exception exc) {
                AstralSorcery.log.warn("Couldn't write source-node data for network node at " + pos.toString() + "!");
                AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                continue;
            }
            source.func_74778_a("sTypeId", sourceNode.getProvider().getIdentifier().toString());
            sourceTag.func_218657_a("source", (INBT)source);
            sourceList.add((Object)sourceTag);
        }
        nbt.func_218657_a("sources", (INBT)sourceList);
    }

    public void addSource(IStarlightSource source, BlockPos pos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getOrCreateSection((Vec3i)pos);
        data.addSourceTile(pos, source);
        IIndependentStarlightSource newSource = this.addIndependentSource(pos, source);
        if (newSource != null) {
            Map<BlockPos, IIndependentStarlightSource> copyTr = Collections.unmodifiableMap(new HashMap<BlockPos, IIndependentStarlightSource>(this.starlightSources));
            Thread tr = new Thread(() -> this.threadedUpdateSourceProximity(copyTr));
            tr.setName("StarlightNetwork-UpdateThread");
            tr.start();
        }
        this.markDirty(data);
    }

    private void threadedUpdateSourceProximity(Map<BlockPos, IIndependentStarlightSource> copyTr) {
        try {
            for (Map.Entry<BlockPos, IIndependentStarlightSource> sourceTuple : copyTr.entrySet()) {
                sourceTuple.getValue().threadedUpdateProximity(sourceTuple.getKey(), copyTr);
            }
        }
        catch (Exception exc) {
            AstralSorcery.log.warn("Failed to update proximity status for source nodes.");
            exc.printStackTrace();
        }
    }

    public void addTransmission(IStarlightTransmission transmission, BlockPos pos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getOrCreateSection((Vec3i)pos);
        data.addTransmissionTile(pos, transmission);
        this.markDirty(data);
    }

    public void removeSource(BlockPos pos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getSection((Vec3i)pos);
        if (data == null) {
            return;
        }
        data.removeSourceTile(pos);
        this.removeIndependentSource(pos);
        Map<BlockPos, IIndependentStarlightSource> copyTr = Collections.unmodifiableMap(new HashMap<BlockPos, IIndependentStarlightSource>(this.starlightSources));
        Thread tr = new Thread(() -> this.threadedUpdateSourceProximity(copyTr));
        tr.setName("StarlightNetwork-UpdateThread");
        tr.start();
        this.checkIntegrity(pos);
        this.markDirty(data);
    }

    public void removeTransmission(BlockPos pos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getSection((Vec3i)pos);
        if (data == null) {
            return;
        }
        data.removeTransmissionTile(pos);
        this.checkIntegrity(pos);
        this.markDirty(data);
    }

    private void checkIntegrity(BlockPos actualPos) {
        ChunkNetworkData data = (ChunkNetworkData)this.getSection((Vec3i)actualPos);
        if (data == null) {
            return;
        }
        data.checkIntegrity();
        if (data.isEmpty()) {
            this.queueRemoval.add(actualPos);
        }
    }

    @Nullable
    private IIndependentStarlightSource addIndependentSource(BlockPos pos, IStarlightSource source) {
        this.cachedSourceTuples = null;
        Object node = source.getNode();
        if (node instanceof ITransmissionSource) {
            IIndependentStarlightSource sourceNode = ((ITransmissionSource)node).provideNewIndependentSource(source);
            this.starlightSources.put(pos, sourceNode);
            return sourceNode;
        }
        return null;
    }

    private void removeIndependentSource(BlockPos pos) {
        this.starlightSources.remove(pos);
        this.cachedSourceTuples = null;
    }

    public static class ChunkSectionNetworkData {
        private Map<BlockPos, IPrismTransmissionNode> nodes = new HashMap<BlockPos, IPrismTransmissionNode>();

        private static ChunkSectionNetworkData loadFromNBT(ListNBT sectionData) {
            ChunkSectionNetworkData netData = new ChunkSectionNetworkData();
            for (int i = 0; i < sectionData.size(); ++i) {
                CompoundNBT nodeComp = sectionData.func_150305_b(i);
                BlockPos pos = NBTHelper.readBlockPosFromNBT(nodeComp);
                CompoundNBT prismComp = nodeComp.func_74775_l("nodeTag");
                ResourceLocation nodeIdentifier = new ResourceLocation(prismComp.func_74779_i("trNodeId"));
                TransmissionProvider provider = TransmissionClassRegistry.getProvider(nodeIdentifier);
                if (provider == null) {
                    AstralSorcery.log.warn("Couldn't load node tile at " + pos + " - invalid identifier: " + nodeIdentifier);
                    continue;
                }
                IPrismTransmissionNode node = (IPrismTransmissionNode)provider.get();
                node.readFromNBT(prismComp);
                netData.nodes.put(pos, node);
            }
            return netData;
        }

        private void writeToNBT(ListNBT sectionData) {
            for (Map.Entry<BlockPos, IPrismTransmissionNode> node : this.nodes.entrySet()) {
                try {
                    CompoundNBT nodeComp = new CompoundNBT();
                    NBTHelper.writeBlockPosToNBT(node.getKey(), nodeComp);
                    CompoundNBT prismComp = new CompoundNBT();
                    IPrismTransmissionNode prismNode = node.getValue();
                    prismNode.writeToNBT(prismComp);
                    prismComp.func_74778_a("trNodeId", prismNode.getProvider().getIdentifier().toString());
                    nodeComp.func_218657_a("nodeTag", (INBT)prismComp);
                    sectionData.add((Object)nodeComp);
                }
                catch (Exception exc) {
                    try {
                        BlockPos at = node.getKey();
                        AstralSorcery.log.warn("Couldn't write node data for network node at " + at.toString() + "!");
                        AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                    }
                    catch (Exception exc2) {
                        try {
                            BlockPos at = node.getValue().getLocationPos();
                            AstralSorcery.log.warn("Couldn't write node data for network node at " + at.toString() + "!");
                            AstralSorcery.log.warn("This is a major problem. To be perfectly save, consider making a backup, then break or mcedit the tileentity out and place a proper/new one...");
                        }
                        catch (Exception exc3) {
                            AstralSorcery.log.warn("Couldn't write node data for a network node! Skipping...");
                        }
                    }
                }
            }
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public Collection<IPrismTransmissionNode> getAllTransmissionNodes() {
            return Collections.unmodifiableCollection(this.nodes.values());
        }

        @Nullable
        public IPrismTransmissionNode getTransmissionNode(BlockPos at) {
            return this.nodes.get(at);
        }

        private void removeSourceTile(BlockPos pos) {
            this.removeNode(pos);
        }

        private void removeTransmissionTile(BlockPos pos) {
            this.removeNode(pos);
        }

        private void removeNode(BlockPos pos) {
            this.nodes.remove(pos);
        }

        private void addSourceTile(BlockPos pos, IStarlightSource source) {
            this.addNode(pos, source);
        }

        private void addTransmissionTile(BlockPos pos, IStarlightTransmission transmission) {
            this.addNode(pos, transmission);
        }

        private void addNode(BlockPos pos, IStarlightTransmission transmission) {
            this.nodes.put(pos, (IPrismTransmissionNode)transmission.provideTransmissionNode(pos));
        }
    }

    public static class ChunkNetworkData
    extends WorldSection {
        private Map<Integer, ChunkSectionNetworkData> sections = new HashMap<Integer, ChunkSectionNetworkData>();

        ChunkNetworkData(int sX, int sZ) {
            super(sX, sZ);
        }

        public void readFromNBT(CompoundNBT tag) {
            for (String key : tag.func_150296_c()) {
                int yLevel;
                try {
                    yLevel = Integer.parseInt(key);
                }
                catch (NumberFormatException exc) {
                    continue;
                }
                ListNBT yData = tag.func_150295_c(key, 10);
                ChunkSectionNetworkData sectionNetData = ChunkSectionNetworkData.loadFromNBT(yData);
                this.sections.put(yLevel, sectionNetData);
            }
        }

        public void writeToNBT(CompoundNBT data) {
            for (Integer yLevel : this.sections.keySet()) {
                ChunkSectionNetworkData sectionData = this.sections.get(yLevel);
                ListNBT sectionTag = new ListNBT();
                sectionData.writeToNBT(sectionTag);
                data.func_218657_a(String.valueOf(yLevel), (INBT)sectionTag);
            }
        }

        @Nullable
        public ChunkSectionNetworkData getSection(int yLevel) {
            return this.sections.get(yLevel);
        }

        public void checkIntegrity() {
            Iterator<Integer> iterator = this.sections.keySet().iterator();
            while (iterator.hasNext()) {
                Integer yLevel = iterator.next();
                ChunkSectionNetworkData data = this.sections.get(yLevel);
                if (!data.isEmpty()) continue;
                iterator.remove();
            }
        }

        public boolean isEmpty() {
            return this.sections.isEmpty();
        }

        private ChunkSectionNetworkData getOrCreateSection(int yLevel) {
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                section = new ChunkSectionNetworkData();
                this.sections.put(yLevel, section);
            }
            return section;
        }

        private void removeSourceTile(BlockPos pos) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                return;
            }
            section.removeSourceTile(pos);
        }

        private void removeTransmissionTile(BlockPos pos) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getSection(yLevel);
            if (section == null) {
                return;
            }
            section.removeTransmissionTile(pos);
        }

        private void addSourceTile(BlockPos pos, IStarlightSource source) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getOrCreateSection(yLevel);
            section.addSourceTile(pos, source);
        }

        private void addTransmissionTile(BlockPos pos, IStarlightTransmission transmission) {
            int yLevel = (pos.func_177956_o() & 0xFF) >> 4;
            ChunkSectionNetworkData section = this.getOrCreateSection(yLevel);
            section.addTransmissionTile(pos, transmission);
        }
    }
}

