/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.storage.StorageNetwork;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.data.WorldCacheDomain;
import hellfirepvp.observerlib.common.data.base.GlobalWorldData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class StorageNetworkBuffer
extends GlobalWorldData {
    private Map<BlockPos, StorageNetwork> rawNetworks = Maps.newHashMap();
    private Map<ChunkPos, List<StorageNetwork>> availableNetworks = Maps.newHashMap();

    public StorageNetworkBuffer(WorldCacheDomain.SaveKey<?> key) {
        super(key);
    }

    @Nullable
    public StorageNetwork getNetwork(BlockPos masterPos) {
        return this.rawNetworks.get(masterPos);
    }

    private void rebuildAccessContext() {
        this.availableNetworks.clear();
        for (StorageNetwork network : this.rawNetworks.values()) {
            for (StorageNetwork.CoreArea core : network.getCores()) {
                AxisAlignedBB box = core.getRealBox();
                ChunkPos from = Vector3.getMin(box).toChunkPos();
                ChunkPos to = Vector3.getMax(box).toChunkPos();
                for (int chX = from.field_77276_a; chX <= to.field_77276_a; ++chX) {
                    for (int chZ = from.field_77275_b; chZ <= to.field_77275_b; ++chZ) {
                        this.availableNetworks.computeIfAbsent(new ChunkPos(chX, chZ), pos -> Lists.newArrayList()).add(network);
                    }
                }
            }
        }
    }

    public void writeToNBT(CompoundNBT compound) {
        ListNBT networks = new ListNBT();
        for (StorageNetwork network : this.rawNetworks.values()) {
            CompoundNBT tag = new CompoundNBT();
            network.writeToNBT(tag);
            networks.add((Object)tag);
        }
        compound.func_218657_a("networks", (INBT)networks);
    }

    public void readFromNBT(CompoundNBT compound) {
        this.rawNetworks.clear();
        ListNBT networks = compound.func_150295_c("networks", 10);
        for (int i = 0; i < networks.size(); ++i) {
            CompoundNBT tag = networks.func_150305_b(i);
            StorageNetwork net = new StorageNetwork();
            net.readFromNBT(tag);
            if (net.getCores().isEmpty()) continue;
            StorageNetwork.CoreArea master = net.getMaster();
            if (master == null) {
                master = MiscUtils.getRandomEntry(net.getCores(), this.rand);
            }
            this.rawNetworks.put(master.getPos(), net);
        }
        this.rebuildAccessContext();
    }

    public void updateTick(World world) {
    }
}

