/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityIlluminationSpark
extends ThrowableEntity {
    public EntityIlluminationSpark(World world) {
        super(EntityTypesAS.ILLUMINATION_SPARK, world);
    }

    public EntityIlluminationSpark(double x, double y, double z, World world) {
        super(EntityTypesAS.ILLUMINATION_SPARK, x, y, z, world);
    }

    public EntityIlluminationSpark(LivingEntity thrower, World world) {
        super(EntityTypesAS.ILLUMINATION_SPARK, thrower, world);
        this.func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 0.7f, 0.9f);
    }

    public static EntityType.IFactory<EntityIlluminationSpark> factory() {
        return (type, world) -> new EntityIlluminationSpark(world);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d()) {
            this.spawnEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnEffects() {
        FXFacingParticle p;
        for (int i = 0; i < 6; ++i) {
            p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this))).setMotion(new Vector3(0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f, 0.04f - this.field_70146_Z.nextFloat() * 0.08f))).setScaleMultiplier(0.25f);
            this.randomizeColor(p);
        }
        p = (FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this));
        p.setScaleMultiplier(0.6f);
        this.randomizeColor(p);
        p = (FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this).add(this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5)));
        p.setScaleMultiplier(0.6f);
        this.randomizeColor(p);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void randomizeColor(FXFacingParticle p) {
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                p.color(VFXColorFunction.constant(ColorsAS.ILLUMINATION_POWDER_1));
                break;
            }
            case 1: {
                p.color(VFXColorFunction.constant(ColorsAS.ILLUMINATION_POWDER_2));
                break;
            }
            case 2: {
                p.color(VFXColorFunction.constant(ColorsAS.ILLUMINATION_POWDER_3));
                break;
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        BlockRayTraceResult brtr;
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        if (!(result instanceof BlockRayTraceResult) || !(this.func_85052_h() instanceof PlayerEntity)) {
            this.func_70106_y();
            return;
        }
        PlayerEntity player = (PlayerEntity)this.func_85052_h();
        BlockItemUseContext bCtx = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, brtr = (BlockRayTraceResult)result));
        BlockPos pos = bCtx.func_195995_a();
        if (!BlockUtils.isReplaceable(this.field_70170_p, pos)) {
            pos = pos.func_177972_a(bCtx.func_196000_l());
        }
        if (!ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.getBlockSnapshot((IWorld)this.field_70170_p, (BlockPos)pos), (Direction)bCtx.func_196000_l())) {
            this.field_70170_p.func_175656_a(pos, BlocksAS.FLARE_LIGHT.func_176223_P());
        }
        this.func_70106_y();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

