/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectPelotrio;
import hellfirepvp.astralsorcery.common.entity.goal.SpectralToolBreakBlockGoal;
import hellfirepvp.astralsorcery.common.entity.goal.SpectralToolGoal;
import hellfirepvp.astralsorcery.common.entity.goal.SpectralToolMeleeAttackGoal;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntitySpectralTool
extends FlyingEntity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntitySpectralTool.class, (IDataSerializer)DataSerializers.field_187196_f);
    private LivingEntity owningEntity = null;
    private SpectralToolGoal task = null;
    private BlockPos startPosition = null;
    private int remainingTime = 0;
    private int idleTime = 0;

    public EntitySpectralTool(World worldIn) {
        super(EntityTypesAS.SPECTRAL_TOOL, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
    }

    public EntitySpectralTool(World worldIn, BlockPos spawnPos, LivingEntity owner, ToolTask task) {
        this(worldIn);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, spawnPos.func_177952_p());
        this.setItem(task.displayStack);
        this.startPosition = spawnPos;
        this.owningEntity = owner;
        this.task = task.createGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.task);
        this.remainingTime = task.maxAge + this.field_70146_Z.nextInt(task.maxAge);
    }

    public static EntityType.IFactory<EntitySpectralTool> factory() {
        return (type, world) -> new EntitySpectralTool(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.85);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().func_201670_d()) {
            this.tickClient();
        } else {
            if (this.startPosition == null) {
                this.func_70106_y();
                return;
            }
            if (!this.task.func_75250_a()) {
                ++this.idleTime;
                if (this.idleTime >= 30) {
                    this.func_70106_y();
                    return;
                }
            } else {
                this.idleTime = 0;
            }
            --this.remainingTime;
            if (this.remainingTime <= 0) {
                DamageUtil.attackEntityFrom((Entity)this, CommonProxy.DAMAGE_SOURCE_STELLAR, 50.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            Vector3 at = Vector3.atEntityCorner((Entity)this).add((double)this.field_70146_Z.nextFloat() * 0.3 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.3 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1) + (double)(this.func_213302_cg() / 2.0f), (double)this.field_70146_Z.nextFloat() * 0.3 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1));
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_TYPE_WEAK))).setScaleMultiplier(0.35f + this.field_70146_Z.nextFloat() * 0.25f)).setMaxAge(30 + this.field_70146_Z.nextInt(20));
            if (this.field_70146_Z.nextBoolean()) {
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.2f + this.field_70146_Z.nextFloat() * 0.15f)).setMaxAge(20 + this.field_70146_Z.nextInt(10));
            }
        }
    }

    public BlockPos getStartPosition() {
        return this.startPosition;
    }

    public LivingEntity getOwningEntity() {
        return this.owningEntity;
    }

    private void setItem(@Nonnull ItemStack tool) {
        this.field_70180_af.func_187227_b(ITEM, (Object)tool);
    }

    @Nonnull
    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void func_70108_f(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !(entityIn instanceof EntitySpectralTool)) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity) && !(entityIn instanceof EntitySpectralTool)) {
            super.func_70108_f(entityIn);
        }
    }

    public static class ToolTask {
        private final int maxAge;
        private final double speed;
        private final ItemStack displayStack;
        private final BiFunction<EntitySpectralTool, Double, SpectralToolGoal> toolGoal;

        protected ToolTask(int maxAge, double speed, ItemStack displayStack, BiFunction<EntitySpectralTool, Double, SpectralToolGoal> toolGoal) {
            this.maxAge = maxAge;
            this.speed = speed;
            this.displayStack = displayStack;
            this.toolGoal = toolGoal;
        }

        public static ToolTask createPickaxeTask() {
            return new ToolTask((Integer)MantleEffectPelotrio.CONFIG.durationPickaxe.get(), (Double)MantleEffectPelotrio.CONFIG.speedPickaxe.get(), new ItemStack((IItemProvider)Items.field_151046_w), SpectralToolBreakBlockGoal::new);
        }

        public static ToolTask createLogTask() {
            return new ToolTask((Integer)MantleEffectPelotrio.CONFIG.durationAxe.get(), (Double)MantleEffectPelotrio.CONFIG.speedAxe.get(), new ItemStack((IItemProvider)Items.field_151056_x), SpectralToolBreakBlockGoal::new);
        }

        public static ToolTask createAttackTask() {
            return new ToolTask((Integer)MantleEffectPelotrio.CONFIG.durationSword.get(), (Double)MantleEffectPelotrio.CONFIG.speedSword.get(), new ItemStack((IItemProvider)Items.field_151048_u), SpectralToolMeleeAttackGoal::new);
        }

        private SpectralToolGoal createGoal(EntitySpectralTool tool) {
            return this.toolGoal.apply(tool, this.speed);
        }
    }
}

