/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.handler;

import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.effect.EffectDropModifier;
import hellfirepvp.astralsorcery.common.lib.CapabilitiesAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHandlerMisc {
    public static void attachListeners(IEventBus bus) {
        bus.addListener(EventHandlerMisc::onSpawnEffectCloud);
        bus.addListener(EventHandlerMisc::onPlayerSleepEclipse);
        bus.addListener(EventHandlerMisc::onChunkLoad);
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        IChunk ch = event.getChunk();
        if (ch instanceof Chunk && !event.getWorld().func_201670_d()) {
            ((Chunk)ch).getCapability(CapabilitiesAS.CHUNK_FLUID).ifPresent(entry -> {
                if (!entry.isInitialized()) {
                    IWorld w = event.getWorld();
                    long seed = w.func_72905_C();
                    long chX = event.getChunk().func_76632_l().field_77276_a;
                    long chZ = event.getChunk().func_76632_l().field_77275_b;
                    seed ^= chX << 32;
                    entry.generate(seed ^= chZ);
                    ((Chunk)ch).func_76630_e();
                }
            });
        }
    }

    private static void onPlayerSleepEclipse(PlayerSleepInBedEvent event) {
        WorldContext ctx = SkyHandler.getContext(event.getEntityLiving().func_130014_f_());
        if (ctx != null && ctx.getCelestialHandler().isSolarEclipseActive() && event.getResultStatus() == null) {
            event.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
    }

    private static void onSpawnEffectCloud(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AreaEffectCloudEntity && MiscUtils.contains(((AreaEffectCloudEntity)event.getEntity()).field_184503_f, effect -> effect.func_188419_a() instanceof EffectDropModifier)) {
            event.setCanceled(true);
        }
    }
}

