/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.GuiType;
import hellfirepvp.astralsorcery.common.constellation.ConstellationBaseItem;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.entity.item.EntityItemExplosionResistant;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemConstellationPaper
extends Item
implements ItemDynamicColor,
ConstellationBaseItem {
    public ItemConstellationPaper() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS_PAPERS));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            for (IConstellation c : ConstellationRegistry.getAllConstellations()) {
                ItemStack cPaper = new ItemStack((IItemProvider)this, 1);
                this.setConstellation(cPaper, c);
                items.add((Object)cPaper);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> toolTip, ITooltipFlag flag) {
        IConstellation c = this.getConstellation(stack);
        if (c != null && c.canDiscover((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ResearchHelper.getClientProgress())) {
            toolTip.add(c.getConstellationName().func_211708_a(TextFormatting.BLUE));
        } else {
            toolTip.add(new TranslationTextComponent("astralsorcery.misc.noinformation", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b()) {
            return ActionResult.func_226248_a_((Object)held);
        }
        if (world.func_201670_d() && this.getConstellation(held) != null) {
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            AstralSorcery.getProxy().openGui(player, GuiType.CONSTELLATION_PAPER, this.getConstellation(held));
        }
        return ActionResult.func_226248_a_((Object)held);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        IConstellation cst;
        EntityItemExplosionResistant res = new EntityItemExplosionResistant(EntityTypesAS.ITEM_EXPLOSION_RESISTANT, world, location.func_226277_ct_(), location.func_226278_cu_(), location.func_226281_cx_(), itemstack);
        res.func_174867_a(20);
        res.func_213317_d(location.func_213322_ci());
        if (location instanceof ItemEntity) {
            res.func_200216_c(((ItemEntity)location).func_200214_m());
            res.func_200217_b(((ItemEntity)location).func_200215_l());
        }
        if (itemstack.func_77973_b() instanceof ItemConstellationPaper && (cst = this.getConstellation(itemstack)) != null) {
            res.applyColor(cst.getConstellationColor());
        }
        return res;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        IConstellation c;
        PlayerProgress progress;
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        IConstellation cst = this.getConstellation(stack);
        if (cst == null) {
            progress = ResearchHelper.getProgress((PlayerEntity)entity, LogicalSide.SERVER);
            ArrayList<IConstellation> constellations = new ArrayList<IConstellation>();
            for (IConstellation c2 : ConstellationRegistry.getAllConstellations()) {
                if (!c2.canDiscover((PlayerEntity)entity, progress)) continue;
                constellations.add(c2);
            }
            for (ResourceLocation strConstellation : progress.getKnownConstellations()) {
                c = ConstellationRegistry.getConstellation(strConstellation);
                if (c == null) continue;
                constellations.remove(c);
            }
            for (ResourceLocation strConstellation : progress.getSeenConstellations()) {
                c = ConstellationRegistry.getConstellation(strConstellation);
                if (c == null) continue;
                constellations.remove(c);
            }
            IConstellation constellation = (IConstellation)MiscUtils.getRandomEntry(constellations, world.field_73012_v);
            if (constellation != null) {
                this.setConstellation(stack, constellation);
            }
        }
        if ((cst = this.getConstellation(stack)) != null) {
            progress = ResearchHelper.getProgress((PlayerEntity)entity, LogicalSide.SERVER);
            boolean has = false;
            for (ResourceLocation strConstellation : progress.getSeenConstellations()) {
                c = ConstellationRegistry.getConstellation(strConstellation);
                if (c == null || !c.equals(cst)) continue;
                has = true;
                break;
            }
            if (!has && cst.canDiscover((PlayerEntity)entity, progress) && ResearchManager.memorizeConstellation(cst, (PlayerEntity)entity)) {
                entity.func_145747_a(new TranslationTextComponent("astralsorcery.progress.constellation.seen.chat", new Object[]{cst.getConstellationName().func_211708_a(TextFormatting.GRAY)}).func_211708_a(TextFormatting.BLUE));
                if (ResearchHelper.getClientProgress().getSeenConstellations().size() == 1) {
                    entity.func_145747_a(new TranslationTextComponent("astralsorcery.progress.constellation.seen.track", new Object[0]).func_211708_a(TextFormatting.BLUE));
                }
            }
        }
        super.func_77663_a(stack, world, entity, slot, isSelected);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return -1;
        }
        IConstellation c = this.getConstellation(stack);
        if (c != null && ResearchHelper.getClientProgress().hasConstellationDiscovered(c)) {
            return 0xFF000000 | c.getConstellationColor().getRGB();
        }
        return -10921639;
    }

    @Override
    @Nullable
    public IConstellation getConstellation(ItemStack stack) {
        return IConstellation.readFromNBT(NBTHelper.getPersistentData(stack));
    }

    @Override
    public boolean setConstellation(ItemStack stack, @Nullable IConstellation constellation) {
        constellation.writeToNBT(NBTHelper.getPersistentData(stack));
        return true;
    }
}

