/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.AreaOfInfluencePreview;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.base.OverrideInteractItem;
import hellfirepvp.astralsorcery.common.lib.CapabilitiesAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.tile.base.TileAreaOfInfluence;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import hellfirepvp.astralsorcery.common.util.world.WorldSeedCache;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class ItemResonator
extends Item
implements OverrideInteractItem {
    public ItemResonator() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
        this.func_185043_a(new ResourceLocation("upgrade"), (stack, world, entity) -> {
            if (!(entity instanceof PlayerEntity)) {
                return (float)ResonatorUpgrade.STARLIGHT.ordinal() / (float)ResonatorUpgrade.values().length;
            }
            ResonatorUpgrade current = ItemResonator.getCurrentUpgrade((PlayerEntity)entity, stack);
            return (float)current.ordinal() / (float)ResonatorUpgrade.values().length;
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack upgradedResonator = new ItemStack((IItemProvider)this);
            ItemResonator.setUpgradeUnlocked(upgradedResonator, ResonatorUpgrade.values());
            items.add((Object)upgradedResonator);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag extended) {
        ResonatorUpgrade current = ItemResonator.getCurrentUpgrade((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack);
        for (ResonatorUpgrade upgrade : ItemResonator.getUpgrades(stack)) {
            TextFormatting color = upgrade.equals((Object)current) ? TextFormatting.GOLD : TextFormatting.BLUE;
            tooltip.add(new TranslationTextComponent(upgrade.getUnlocalizedTypeName(), new Object[0]).func_150255_a(new Style().func_150238_a(color)));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!selected) {
            boolean bl = selected = entity instanceof LivingEntity && ((LivingEntity)entity).func_184592_cb() == stack;
        }
        if (!world.func_201670_d()) {
            ServerPlayerEntity player;
            if (selected && entity instanceof ServerPlayerEntity && ItemResonator.getCurrentUpgrade((PlayerEntity)(player = (ServerPlayerEntity)entity), stack) == ResonatorUpgrade.FLUID_FIELDS) {
                float distribution = DayTimeHelper.getCurrentDaytimeDistribution(world);
                if ((double)distribution <= 1.0E-4) {
                    return;
                }
                if (field_77697_d.nextFloat() < distribution && field_77697_d.nextInt(12) == 0) {
                    int offsetX = field_77697_d.nextInt(30) * (field_77697_d.nextBoolean() ? 1 : -1);
                    int offsetZ = field_77697_d.nextInt(30) * (field_77697_d.nextBoolean() ? 1 : -1);
                    BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vec3i)entity.func_180425_c()).func_177982_a(offsetX, 0, offsetZ));
                    if (pos.func_177951_i((Vec3i)entity.func_180425_c()) > 5625.0) {
                        return;
                    }
                    IChunk ch = world.func_217349_x(pos);
                    if (ch instanceof Chunk) {
                        ((Chunk)ch).getCapability(CapabilitiesAS.CHUNK_FLUID).ifPresent(entry -> {
                            FluidStack display = entry.drain(1, true);
                            if (!display.isEmpty()) {
                                PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIQUID_FOUNTAIN).addData(buf -> {
                                    ByteBufUtils.writeFluidStack(buf, display);
                                    ByteBufUtils.writeVector(buf, new Vector3((Vec3i)pos));
                                });
                                PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((IWorld)world, (Vec3i)pos, 32.0));
                            }
                        });
                    }
                }
            }
        } else {
            this.clientInventoryTick(stack, world, entity, slot, selected);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientInventoryTick(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (selected && ItemResonator.getCurrentUpgrade(player, stack) == ResonatorUpgrade.STARLIGHT && WorldSeedCache.getSeedIfPresent(world).isPresent()) {
            float distribution = DayTimeHelper.getCurrentDaytimeDistribution(world);
            if ((double)distribution <= 1.0E-4) {
                return;
            }
            BlockPos center = player.func_180425_c();
            int offsetX = center.func_177958_n();
            int offsetZ = center.func_177952_p();
            try (BlockPos.PooledMutable pool = BlockPos.PooledMutable.func_185346_s();){
                for (int xx = -30; xx <= 30; ++xx) {
                    for (int zz = -30; zz <= 30; ++zz) {
                        pool.func_189533_g((Vec3i)world.func_205770_a(Heightmap.Type.WORLD_SURFACE, (BlockPos)pool.func_181079_c(offsetX + xx, 0, offsetZ + zz)));
                        float perc = SkyCollectionHelper.getSkyNoiseDistributionClient(world, (BlockPos)pool).get().floatValue();
                        float fPerc = (float)Math.pow((perc - 0.4f) * 1.65f, 2.0);
                        if (!(perc >= 0.4f) || !(field_77697_d.nextFloat() <= fPerc) || !(field_77697_d.nextFloat() <= fPerc) || field_77697_d.nextInt(6) != 0) continue;
                        ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vec3i)pool).add((double)field_77697_d.nextFloat(), 0.15, (double)field_77697_d.nextFloat()))).color(VFXColorFunction.constant(ColorsAS.RESONATOR_STARFIELD))).setScaleMultiplier(4.0f)).setAlphaMultiplier(distribution * fPerc);
                        if (!(perc >= 0.8f) || field_77697_d.nextInt(3) != 0) continue;
                        ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vec3i)pool).add((double)field_77697_d.nextFloat(), 0.15, (double)field_77697_d.nextFloat()))).setScaleMultiplier(0.3f)).color(VFXColorFunction.WHITE)).setGravityStrength(-0.001f)).setAlphaMultiplier(distribution);
                    }
                }
            }
        }
    }

    @Override
    public boolean shouldInterceptInteract(LogicalSide side, PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        ResonatorUpgrade upgrade = ItemResonator.getCurrentUpgrade(player, player.func_184586_b(hand));
        return upgrade == ResonatorUpgrade.AREA_SIZE && MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), pos, TileAreaOfInfluence.class, false) != null;
    }

    @Override
    public boolean doInteract(LogicalSide side, PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        TileAreaOfInfluence aoeTile;
        ResonatorUpgrade upgrade = ItemResonator.getCurrentUpgrade(player, player.func_184586_b(hand));
        if (upgrade == ResonatorUpgrade.AREA_SIZE && player.func_130014_f_().func_201670_d() && (aoeTile = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), pos, TileAreaOfInfluence.class, false)) != null) {
            this.playAreaOfInfluenceEffect(aoeTile);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playAreaOfInfluenceEffect(TileAreaOfInfluence aoeTile) {
        AreaOfInfluencePreview.INSTANCE.show(aoeTile);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.func_201670_d() && player.func_225608_bj_() && ItemResonator.cycleUpgrade(player, player.func_184586_b(hand))) {
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public static boolean cycleUpgrade(@Nonnull PlayerEntity player, ItemStack stack) {
        ResonatorUpgrade current = ItemResonator.getCurrentUpgrade(player, stack);
        ResonatorUpgrade next = ItemResonator.getNextSelectableUpgrade(player, stack);
        return next != null && !next.equals((Object)current) && ItemResonator.setCurrentUpgrade(player, stack, next);
    }

    @Nullable
    public static ResonatorUpgrade getNextSelectableUpgrade(@Nonnull PlayerEntity viewing, ItemStack stack) {
        int currentOrd;
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return null;
        }
        ResonatorUpgrade current = ItemResonator.getCurrentUpgrade(viewing, stack);
        int test = currentOrd = current.ordinal();
        do {
            ++test;
            ResonatorUpgrade testUpgrade = ResonatorUpgrade.values()[test %= ResonatorUpgrade.values().length];
            if (!testUpgrade.canSwitchTo(viewing, stack) || testUpgrade.equals((Object)current)) continue;
            return testUpgrade;
        } while (test != currentOrd);
        return null;
    }

    public static boolean setCurrentUpgrade(PlayerEntity setting, ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return false;
        }
        if (upgrade.canSwitchTo(setting, stack)) {
            NBTHelper.getPersistentData(stack).func_74768_a("selected_upgrade", upgrade.ordinal());
            return true;
        }
        return false;
    }

    public static ItemStack setCurrentUpgradeUnsafe(ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return stack;
        }
        NBTHelper.getPersistentData(stack).func_74768_a("selected_upgrade", upgrade.ordinal());
        return stack;
    }

    @Nonnull
    public static ResonatorUpgrade getCurrentUpgrade(@Nullable PlayerEntity viewing, ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return ResonatorUpgrade.STARLIGHT;
        }
        CompoundNBT cmp = NBTHelper.getPersistentData(stack);
        int current = cmp.func_74762_e("selected_upgrade");
        ResonatorUpgrade upgrade = ResonatorUpgrade.values()[MathHelper.func_76125_a((int)current, (int)0, (int)(ResonatorUpgrade.values().length - 1))];
        if (viewing != null && !upgrade.canSwitchTo(viewing, stack)) {
            return ResonatorUpgrade.STARLIGHT;
        }
        return upgrade;
    }

    public static ItemStack setUpgradeUnlocked(ItemStack stack, ResonatorUpgrade ... upgrades) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return stack;
        }
        for (ResonatorUpgrade upgrade : upgrades) {
            upgrade.applyUpgrade(stack);
        }
        return stack;
    }

    public static boolean hasUpgrade(ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return false;
        }
        return upgrade.hasUpgrade(stack);
    }

    public static List<ResonatorUpgrade> getUpgrades(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemResonator)) {
            return Lists.newArrayList();
        }
        LinkedList upgrades = Lists.newLinkedList();
        for (ResonatorUpgrade ru : ResonatorUpgrade.values()) {
            if (!ru.hasUpgrade(stack)) continue;
            upgrades.add(ru);
        }
        return upgrades;
    }

    public String func_77667_c(ItemStack stack) {
        return ItemResonator.getCurrentUpgrade(null, stack).getUnlocalizedItemName();
    }

    public static enum ResonatorUpgrade {
        STARLIGHT("starlight", (TriPredicate<PlayerEntity, LogicalSide, ItemStack>)((TriPredicate)(player, side, stack) -> true)),
        FLUID_FIELDS("liquid", (TriPredicate<PlayerEntity, LogicalSide, ItemStack>)((TriPredicate)(player, side, stack) -> ResearchHelper.getProgress(player, side).getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT))),
        AREA_SIZE("structure", (TriPredicate<PlayerEntity, LogicalSide, ItemStack>)((TriPredicate)(player, side, stack) -> ResearchHelper.getProgress(player, side).getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)));

        private final TriPredicate<PlayerEntity, LogicalSide, ItemStack> check;
        private final String appendixUpgrade;

        private ResonatorUpgrade(String appendixUpgrade, TriPredicate<PlayerEntity, LogicalSide, ItemStack> check) {
            this.check = check;
            this.appendixUpgrade = appendixUpgrade;
        }

        public String getUnlocalizedItemName() {
            return "item.astralsorcery.resonator." + this.appendixUpgrade;
        }

        public String getUnlocalizedTypeName() {
            return "item.astralsorcery.resonator.upgrade." + this.appendixUpgrade;
        }

        public boolean hasUpgrade(ItemStack stack) {
            int id = this.ordinal();
            CompoundNBT cmp = NBTHelper.getPersistentData(stack);
            if (cmp.func_150297_b("upgrades", 9)) {
                ListNBT list = cmp.func_150295_c("upgrades", 3);
                for (int i = 0; i < list.size(); ++i) {
                    if (list.func_186858_c(i) != id) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canSwitchTo(@Nonnull PlayerEntity player, ItemStack stack) {
            return this.hasUpgrade(stack) && this.check.test((Object)player, (Object)EffectiveSide.get(), (Object)stack);
        }

        public void applyUpgrade(ItemStack stack) {
            if (this.hasUpgrade(stack)) {
                return;
            }
            CompoundNBT cmp = NBTHelper.getPersistentData(stack);
            if (!cmp.func_150297_b("upgrades", 9)) {
                cmp.func_218657_a("upgrades", (INBT)new ListNBT());
            }
            ListNBT list = cmp.func_150295_c("upgrades", 3);
            list.add((Object)IntNBT.func_229692_a_((int)this.ordinal()));
        }
    }
}

