/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.base;

import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public interface ItemBlockStorage {
    public static final Random random = new Random();

    public static boolean storeBlockState(ItemStack stack, World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) || state.func_185887_b((IBlockReader)world, pos) == -1.0f || ItemUtils.createBlockStack(state).func_190926_b()) {
            return false;
        }
        CompoundNBT persistent = NBTHelper.getPersistentData(stack);
        ListNBT stored = persistent.func_150295_c("storedStates", 10);
        stored.add((Object)NBTHelper.getBlockStateNBTTag(state));
        persistent.func_218657_a("storedStates", (INBT)stored);
        return true;
    }

    public static void clearContainerFor(PlayerEntity player) {
        Tuple<Hand, ItemStack> held = MiscUtils.getMainOrOffHand((LivingEntity)player, stack -> stack.func_77973_b() instanceof ItemBlockStorage);
        if (held != null) {
            NBTHelper.getPersistentData((ItemStack)held.func_76340_b()).func_82580_o("storedStates");
        }
    }

    @Nonnull
    public static List<Tuple<ItemStack, Integer>> getInventoryMatchingItemStacks(PlayerEntity player, ItemStack referenceContainer) {
        Map<BlockState, Tuple<ItemStack, Integer>> storedStates = ItemBlockStorage.getInventoryMatching(player, referenceContainer);
        ArrayList<Tuple<ItemStack, Integer>> foundStacks = new ArrayList<Tuple<ItemStack, Integer>>(storedStates.values());
        foundStacks.sort(Comparator.comparing(tpl -> ((ItemStack)tpl.func_76341_a()).func_77973_b().getRegistryName()));
        return foundStacks;
    }

    @Nonnull
    public static Map<BlockState, Tuple<ItemStack, Integer>> getInventoryMatching(PlayerEntity player, ItemStack referenceContainer) {
        Map<BlockState, ItemStack> mappedStacks = ItemBlockStorage.getMappedStoredStates(referenceContainer);
        HashMap<BlockState, Tuple<ItemStack, Integer>> foundContents = new HashMap<BlockState, Tuple<ItemStack, Integer>>();
        for (BlockState state : mappedStacks.keySet()) {
            ItemStack stored = mappedStacks.get(state);
            int countDisplay = 0;
            Collection<ItemStack> stacks = ItemUtils.findItemsInPlayerInventory(player, stored, true);
            for (ItemStack found : stacks) {
                countDisplay += found.func_190916_E();
            }
            foundContents.put(state, (Tuple<ItemStack, Integer>)new Tuple((Object)stored.func_77946_l(), (Object)countDisplay));
        }
        return foundContents;
    }

    @Nonnull
    public static Map<BlockState, ItemStack> getMappedStoredStates(ItemStack referenceContainer) {
        NonNullList<BlockState> blockStates = ItemBlockStorage.getStoredStates(referenceContainer);
        LinkedHashMap<BlockState, ItemStack> map = new LinkedHashMap<BlockState, ItemStack>();
        for (BlockState state : blockStates) {
            ItemStack stack = ItemUtils.createBlockStack(state);
            if (stack.func_190926_b()) continue;
            map.put(state, stack);
        }
        return map;
    }

    @Nonnull
    public static NonNullList<BlockState> getStoredStates(ItemStack referenceContainer) {
        NonNullList states = NonNullList.func_191196_a();
        if (!referenceContainer.func_190926_b() && referenceContainer.func_77973_b() instanceof ItemBlockStorage) {
            CompoundNBT persistent = NBTHelper.getPersistentData(referenceContainer);
            ListNBT stored = persistent.func_150295_c("storedStates", 10);
            for (int i = 0; i < stored.size(); ++i) {
                BlockState state = NBTHelper.getBlockStateFromTag(stored.func_150305_b(i));
                if (state == null) continue;
                states.add((Object)state);
            }
        }
        return states;
    }

    public static Random getPreviewRandomFromWorld(World world) {
        long tempSeed = 7508891506429673237L;
        return new Random(tempSeed *= world.func_82737_E() / 40L << 8);
    }
}

