/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.useables;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.PerkExperienceRevealer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemShiftingStar
extends Item
implements PerkExperienceRevealer {
    public ItemShiftingStar() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IMajorConstellation cst = this.getBaseConstellation();
        if (cst != null) {
            if (ResearchHelper.getClientProgress().hasConstellationDiscovered(cst)) {
                tooltip.add(cst.getConstellationName().func_211708_a(TextFormatting.BLUE));
            } else {
                tooltip.add(new TranslationTextComponent("astralsorcery.misc.noinformation", new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!worldIn.func_201670_d() && entityLiving instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
            IMajorConstellation cst = this.getBaseConstellation();
            if (cst != null) {
                PlayerProgress prog = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.SERVER);
                if (!(prog.isValid() && prog.wasOnceAttuned() && prog.hasConstellationDiscovered(cst))) {
                    return stack;
                }
                double perkExp = prog.getPerkExp();
                if (ResearchManager.setAttunedConstellation((PlayerEntity)player, cst)) {
                    ResearchManager.setExp((PlayerEntity)player, MathHelper.func_76124_d((double)perkExp));
                    player.func_145747_a(new TranslationTextComponent("astralsorcery.progress.switch.attunement", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
                    SoundHelper.playSoundAround(SoundEvents.field_187561_bM, worldIn, (Vec3i)entityLiving.func_180425_c(), 1.0f, 1.0f);
                }
            } else if (ResearchManager.setAttunedConstellation((PlayerEntity)player, null)) {
                player.func_145747_a(new TranslationTextComponent("astralsorcery.progress.remove.attunement", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
                SoundHelper.playSoundAround(SoundEvents.field_187561_bM, worldIn, (Vec3i)entityLiving.func_180425_c(), 1.0f, 1.0f);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.func_130014_f_().func_201670_d()) {
            this.playUseEffects(player, this.func_77626_a(stack) - count, this.func_77626_a(stack));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playUseEffects(LivingEntity player, int tick, int total) {
        IMajorConstellation cst = this.getBaseConstellation();
        if (cst == null) {
            FXFacingParticle p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)player).addY(player.func_213302_cg() / 2.0f))).setMotion(new Vector3(-0.1 + (double)field_77697_d.nextFloat() * 0.2, 0.01, -0.1 + (double)field_77697_d.nextFloat() * 0.2))).setScaleMultiplier(0.2f + field_77697_d.nextFloat());
            if (field_77697_d.nextBoolean()) {
                p.color(VFXColorFunction.WHITE);
            }
        } else {
            float percCycle = (float)((double)((float)(tick % total) / (float)total * 2.0f) * Math.PI);
            int parts = 5;
            for (int i = 0; i < parts; ++i) {
                float angleSwirl = 75.0f;
                Vector3 center = Vector3.atEntityCorner((Entity)player).addY(player.func_213302_cg() / 2.0f);
                Vector3 v = Vector3.RotAxis.X_AXIS.clone();
                float originalAngle = (float)i / (float)parts * 360.0f;
                double angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
                v.rotate(-Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(4);
                Vector3 pos = center.clone().add(v);
                Vector3 mot = center.clone().subtract(pos).normalize().multiply(0.1);
                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).setScaleMultiplier(0.25f + field_77697_d.nextFloat() * 0.4f)).setMotion(mot)).setMaxAge(50);
                if (field_77697_d.nextInt(4) == 0) {
                    p.color(VFXColorFunction.WHITE);
                    continue;
                }
                if (field_77697_d.nextInt(3) == 0) {
                    p.color(VFXColorFunction.constant(cst.getConstellationColor().brighter()));
                    continue;
                }
                p.color(VFXColorFunction.constant(cst.getConstellationColor()));
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return this.getBaseConstellation() == null ? 60 : 100;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Nullable
    public IMajorConstellation getBaseConstellation() {
        return null;
    }
}

