/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.login.server;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.network.base.ASLoginPacket;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktLoginSyncGateway
extends ASLoginPacket<PktLoginSyncGateway> {
    private Map<ResourceLocation, List<GatewayCache.GatewayNode>> positions = new HashMap<ResourceLocation, List<GatewayCache.GatewayNode>>();

    public static PktLoginSyncGateway makeLogin() {
        PktLoginSyncGateway pkt = new PktLoginSyncGateway();
        pkt.positions = CelestialGatewayHandler.INSTANCE.getGatewayCache(LogicalSide.SERVER);
        return pkt;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktLoginSyncGateway> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.positions.size());
            for (ResourceLocation dim : packet.positions.keySet()) {
                List<GatewayCache.GatewayNode> gatewayNodes = packet.positions.get(dim);
                ByteBufUtils.writeResourceLocation(buffer, dim);
                buffer.writeInt(gatewayNodes.size());
                for (GatewayCache.GatewayNode node : gatewayNodes) {
                    ByteBufUtils.writePos(buffer, node);
                    ByteBufUtils.writeString(buffer, node.getDisplayName());
                }
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktLoginSyncGateway> decoder() {
        return buffer -> {
            PktLoginSyncGateway pkt = new PktLoginSyncGateway();
            int dimSize = buffer.readInt();
            for (int i = 0; i < dimSize; ++i) {
                ResourceLocation dim = ByteBufUtils.readResourceLocation(buffer);
                int nodeCount = buffer.readInt();
                for (int j = 0; j < nodeCount; ++j) {
                    GatewayCache.GatewayNode newNode = new GatewayCache.GatewayNode(ByteBufUtils.readPos(buffer), ByteBufUtils.readString(buffer));
                    pkt.positions.computeIfAbsent(dim, ii -> new LinkedList()).add(newNode);
                }
            }
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktLoginSyncGateway> handler() {
        return new ASPacket.Handler<PktLoginSyncGateway>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktLoginSyncGateway packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    CelestialGatewayHandler.INSTANCE.updateClientCache(packet.positions);
                    PktLoginSyncGateway.this.acknowledge(context);
                });
            }

            @Override
            public void handle(PktLoginSyncGateway packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

