/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.login.server;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.network.base.ASLoginPacket;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.data.PerkTreeData;
import hellfirepvp.astralsorcery.common.perk.data.PerkTreeLoader;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktLoginSyncPerkInformation
extends ASLoginPacket<PktLoginSyncPerkInformation> {
    private List<JsonObject> rawPerkTreeData = new ArrayList<JsonObject>();
    private int maxLevel = 0;

    public static PktLoginSyncPerkInformation makeLogin() {
        PktLoginSyncPerkInformation pkt = new PktLoginSyncPerkInformation();
        PerkTree.PERK_TREE.getLoginPerkData().ifPresent(treeData -> pkt.rawPerkTreeData.addAll((Collection<JsonObject>)treeData));
        pkt.maxLevel = PerkLevelManager.getLevelCap(LogicalSide.SERVER, null);
        return pkt;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktLoginSyncPerkInformation> encoder() {
        return (pkt, buf) -> {
            ByteBufUtils.writeList(buf, pkt.rawPerkTreeData, ByteBufUtils::writeJsonObject);
            buf.writeInt(pkt.maxLevel);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktLoginSyncPerkInformation> decoder() {
        return buf -> {
            PktLoginSyncPerkInformation pkt = new PktLoginSyncPerkInformation();
            pkt.rawPerkTreeData = ByteBufUtils.readList(buf, ByteBufUtils::readJsonObject);
            pkt.maxLevel = buf.readInt();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktLoginSyncPerkInformation> handler() {
        return new ASPacket.Handler<PktLoginSyncPerkInformation>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktLoginSyncPerkInformation packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    PerkTreeData treeData = PerkTreeLoader.loadPerkTree(packet.rawPerkTreeData);
                    PerkTree.PERK_TREE.receivePerkTree(treeData.prepare());
                    PerkLevelManager.receiveLevelCap(packet.maxLevel);
                    PktLoginSyncPerkInformation.this.acknowledge(context);
                });
            }

            @Override
            public void handle(PktLoginSyncPerkInformation packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

