/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.node.GemSlotPerk;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class PktPerkGemModification
extends ASPacket<PktPerkGemModification> {
    private int action = 0;
    private ResourceLocation perkKey = null;
    private int slotId = -1;

    public static PktPerkGemModification insertItem(AbstractPerk perk, int slotId) {
        PktPerkGemModification pkt = new PktPerkGemModification();
        pkt.action = 0;
        pkt.perkKey = perk.getRegistryName();
        pkt.slotId = slotId;
        return pkt;
    }

    public static PktPerkGemModification dropItem(AbstractPerk perk) {
        PktPerkGemModification pkt = new PktPerkGemModification();
        pkt.action = 1;
        pkt.perkKey = perk.getRegistryName();
        return pkt;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktPerkGemModification> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.action);
            ByteBufUtils.writeOptional(buffer, packet.perkKey, ByteBufUtils::writeResourceLocation);
            buffer.writeInt(packet.slotId);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktPerkGemModification> decoder() {
        return buffer -> {
            PktPerkGemModification pkt = new PktPerkGemModification();
            pkt.action = buffer.readInt();
            pkt.perkKey = ByteBufUtils.readOptional(buffer, ByteBufUtils::readResourceLocation);
            pkt.slotId = buffer.readInt();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktPerkGemModification> handler() {
        return (packet, context, side) -> context.enqueueWork(() -> PerkTree.PERK_TREE.getPerk(side, packet.perkKey).ifPresent(perk -> {
            ServerPlayerEntity player = context.getSender();
            if (!(perk instanceof GemSlotPerk)) {
                return;
            }
            switch (packet.action) {
                case 0: {
                    ItemStack stack = player.field_71071_by.func_70301_a(packet.slotId);
                    ItemStack toInsert = ItemUtils.copyStackWithSize(stack, 1);
                    if (toInsert.func_190926_b() || !(toInsert.func_77973_b() instanceof ItemPerkGem) || DynamicModifierHelper.getStaticModifiers(toInsert).isEmpty() || ((GemSlotPerk)((Object)perk)).hasItem((PlayerEntity)player, LogicalSide.SERVER) || !((GemSlotPerk)((Object)perk)).setContainedItem((PlayerEntity)player, LogicalSide.SERVER, toInsert)) break;
                    player.field_71071_by.func_70299_a(packet.slotId, ItemUtils.copyStackWithSize(stack, stack.func_190916_E() - 1));
                    break;
                }
                case 1: {
                    if (!((GemSlotPerk)((Object)perk)).hasItem((PlayerEntity)player, LogicalSide.SERVER)) break;
                    ((GemSlotPerk)((Object)perk)).dropItemToPlayer((PlayerEntity)player);
                    break;
                }
            }
        }));
    }
}

