/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktPlayLiquidInteraction
extends ASPacket<PktPlayLiquidInteraction> {
    private FluidStack comp1;
    private FluidStack comp2;
    private Vector3 pos;

    public PktPlayLiquidInteraction() {
    }

    public PktPlayLiquidInteraction(FluidStack comp1, FluidStack comp2, Vector3 pos) {
        this.comp1 = comp1;
        this.comp2 = comp2;
        this.pos = pos;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktPlayLiquidInteraction> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeFluidStack(buffer, packet.comp1);
            ByteBufUtils.writeFluidStack(buffer, packet.comp2);
            ByteBufUtils.writeVector(buffer, packet.pos);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktPlayLiquidInteraction> decoder() {
        return buffer -> new PktPlayLiquidInteraction(ByteBufUtils.readFluidStack(buffer), ByteBufUtils.readFluidStack(buffer), ByteBufUtils.readVector(buffer));
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktPlayLiquidInteraction> handler() {
        return new ASPacket.Handler<PktPlayLiquidInteraction>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktPlayLiquidInteraction packet, NetworkEvent.Context context) {
                Optional mcWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT);
                context.enqueueWork(() -> {});
            }

            @Override
            public void handle(PktPlayLiquidInteraction packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

