/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.data.research.ResearchSyncHelper;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncKnowledge
extends ASPacket<PktSyncKnowledge> {
    public static final byte STATE_ADD = 0;
    public static final byte STATE_WIPE = 1;
    private byte state;
    public List<ResourceLocation> knownConstellations = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> seenConstellations = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> storedConstellationPapers = new ArrayList<ResourceLocation>();
    public List<ResearchProgression> researchProgression = new ArrayList<ResearchProgression>();
    public IMajorConstellation attunedConstellation = null;
    public Map<ResourceLocation, CompoundNBT> usedPerks = new HashMap<ResourceLocation, CompoundNBT>();
    public List<String> freePointTokens = Lists.newArrayList();
    public List<ResourceLocation> sealedPerks = Lists.newArrayList();
    public boolean wasOnceAttuned = false;
    public int progressTier = 0;
    public double perkExp = 0.0;

    public PktSyncKnowledge() {
    }

    public PktSyncKnowledge(byte state) {
        this.state = state;
    }

    public void load(PlayerProgress progress) {
        this.knownConstellations = progress.getKnownConstellations();
        this.seenConstellations = progress.getSeenConstellations();
        this.storedConstellationPapers = progress.getStoredConstellationPapers();
        this.researchProgression = progress.getResearchProgression();
        this.progressTier = progress.getTierReached().ordinal();
        this.attunedConstellation = progress.getAttunedConstellation();
        this.freePointTokens = progress.getFreePointTokens();
        this.usedPerks = MapStream.of(progress.getUnlockedPerkData()).mapKey(AbstractPerk::getRegistryName).toMap();
        this.sealedPerks = progress.getSealedPerks().stream().map(AbstractPerk::getRegistryName).collect(Collectors.toList());
        this.perkExp = progress.getPerkExp();
        this.wasOnceAttuned = progress.wasOnceAttuned();
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncKnowledge> encoder() {
        return (packet, buffer) -> {
            buffer.writeByte((int)packet.state);
            ByteBufUtils.writeMap(buffer, packet.usedPerks, ByteBufUtils::writeResourceLocation, ByteBufUtils::writeNBTTag);
            ByteBufUtils.writeList(buffer, packet.sealedPerks, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeList(buffer, packet.knownConstellations, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeList(buffer, packet.seenConstellations, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeList(buffer, packet.storedConstellationPapers, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeList(buffer, packet.researchProgression, ByteBufUtils::writeEnumValue);
            ByteBufUtils.writeOptional(buffer, packet.attunedConstellation, ByteBufUtils::writeRegistryEntry);
            ByteBufUtils.writeList(buffer, packet.freePointTokens, ByteBufUtils::writeString);
            buffer.writeBoolean(packet.wasOnceAttuned);
            buffer.writeInt(packet.progressTier);
            buffer.writeDouble(packet.perkExp);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncKnowledge> decoder() {
        return buffer -> {
            PktSyncKnowledge pkt = new PktSyncKnowledge(buffer.readByte());
            pkt.usedPerks = ByteBufUtils.readMap(buffer, ByteBufUtils::readResourceLocation, ByteBufUtils::readNBTTag);
            pkt.sealedPerks = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.knownConstellations = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.seenConstellations = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.storedConstellationPapers = ByteBufUtils.readList(buffer, ByteBufUtils::readResourceLocation);
            pkt.researchProgression = ByteBufUtils.readList(buffer, buf -> ByteBufUtils.readEnumValue(buf, ResearchProgression.class));
            pkt.attunedConstellation = ByteBufUtils.readOptional(buffer, ByteBufUtils::readRegistryEntry);
            pkt.freePointTokens = ByteBufUtils.readList(buffer, ByteBufUtils::readString);
            pkt.wasOnceAttuned = buffer.readBoolean();
            pkt.progressTier = buffer.readInt();
            pkt.perkExp = buffer.readDouble();
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncKnowledge> handler() {
        return new ASPacket.Handler<PktSyncKnowledge>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncKnowledge packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        if (packet.state == 0) {
                            ResearchSyncHelper.recieveProgressFromServer(packet, (PlayerEntity)player);
                        } else {
                            ResearchHelper.updateClientResearch(null);
                        }
                    }
                });
            }

            @Override
            public void handle(PktSyncKnowledge packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

