/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncPerkActivity
extends ASPacket<PktSyncPerkActivity> {
    private Type type = null;
    private ResourceLocation perkKey = null;
    private CompoundNBT newData = null;
    private CompoundNBT oldData = null;

    public PktSyncPerkActivity() {
    }

    public PktSyncPerkActivity(Type type) {
        if (type == Type.DATACHANGE) {
            throw new IllegalArgumentException("Passed Datachange-Type without supplying data!");
        }
        this.type = type;
    }

    public PktSyncPerkActivity(AbstractPerk perk, CompoundNBT oldData, CompoundNBT newData) {
        this.type = Type.DATACHANGE;
        this.perkKey = perk.getRegistryName();
        this.oldData = oldData;
        this.newData = newData;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncPerkActivity> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.type, ByteBufUtils::writeEnumValue);
            ByteBufUtils.writeOptional(buffer, packet.perkKey, ByteBufUtils::writeResourceLocation);
            ByteBufUtils.writeOptional(buffer, packet.newData, ByteBufUtils::writeNBTTag);
            ByteBufUtils.writeOptional(buffer, packet.oldData, ByteBufUtils::writeNBTTag);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncPerkActivity> decoder() {
        return buffer -> {
            PktSyncPerkActivity pkt = new PktSyncPerkActivity();
            pkt.type = ByteBufUtils.readOptional(buffer, byteBuf -> ByteBufUtils.readEnumValue(byteBuf, Type.class));
            pkt.perkKey = ByteBufUtils.readOptional(buffer, ByteBufUtils::readResourceLocation);
            pkt.newData = ByteBufUtils.readOptional(buffer, ByteBufUtils::readNBTTag);
            pkt.oldData = ByteBufUtils.readOptional(buffer, ByteBufUtils::readNBTTag);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncPerkActivity> handler() {
        return new ASPacket.Handler<PktSyncPerkActivity>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncPerkActivity packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player == null) {
                        return;
                    }
                    switch (packet.type) {
                        case CLEARALL: {
                            PerkEffectHelper.clientClearAllPerks();
                            break;
                        }
                        case UNLOCKALL: {
                            PerkEffectHelper.clientRefreshAllPerks();
                            break;
                        }
                        case DATACHANGE: {
                            PerkTree.PERK_TREE.getPerk(LogicalSide.CLIENT, packet.perkKey).ifPresent(perk -> PerkEffectHelper.clientChangePerkData(perk, packet.oldData, packet.newData));
                            break;
                        }
                    }
                });
            }

            @Override
            public void handle(PktSyncPerkActivity packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }

    public static enum Type {
        CLEARALL,
        UNLOCKALL,
        DATACHANGE;

    }
}

