/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PerkAttributeHelper {
    private static Map<UUID, PerkAttributeMap> playerPerkAttributes = new HashMap<UUID, PerkAttributeMap>();
    private static Map<UUID, PerkAttributeMap> playerPerkAttributesClient = new HashMap<UUID, PerkAttributeMap>();

    private PerkAttributeHelper() {
    }

    @Nonnull
    public static PerkAttributeMap getOrCreateMap(PlayerEntity player, LogicalSide dist) {
        if (dist.isClient()) {
            return playerPerkAttributesClient.computeIfAbsent(player.func_110124_au(), uuid -> new PerkAttributeMap(dist));
        }
        return playerPerkAttributes.computeIfAbsent(player.func_110124_au(), uuid -> new PerkAttributeMap(dist));
    }

    public static PerkAttributeMap getMockInstance(LogicalSide side) {
        return new PerkAttributeMap(side);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clearClient() {
        playerPerkAttributesClient.clear();
    }

    public static void clearServer() {
        playerPerkAttributes.clear();
    }
}

