/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.fml.LogicalSide;

public class PerkAttributeMap {
    private LogicalSide side;
    private Map<PerkAttributeType, List<PerkAttributeModifier>> modifiers = new HashMap<PerkAttributeType, List<PerkAttributeModifier>>();
    private List<PerkConverter> converters = new ArrayList<PerkConverter>();

    PerkAttributeMap(LogicalSide side) {
        this.side = side;
    }

    void applyModifier(@Nonnull PlayerEntity player, @Nonnull PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
        PlayerProgress prog = ResearchHelper.getProgress(player, this.side);
        ArrayList modify = Lists.newArrayList();
        modify.add(modifier);
        modify.addAll(this.gainModifiers(player, prog, modifier, owningSource));
        Iterator iterator = modify.iterator();
        while (iterator.hasNext()) {
            PerkAttributeModifier mod;
            PerkAttributeModifier preMod = mod = (PerkAttributeModifier)((Object)iterator.next());
            LogCategory.PERKS.info(() -> "Applying unique modifier " + preMod.getComparisonKey());
            PerkAttributeModifier postMod = mod = this.convertModifier(player, prog, mod, owningSource);
            LogCategory.PERKS.info(() -> "Applying converted modifier " + postMod.getComparisonKey());
            if (this.cacheModifier(player, mod.getAttributeType(), mod)) continue;
            LogCategory.PERKS.warn(() -> "Could not apply modifier " + postMod.getComparisonKey() + " - already applied!");
        }
    }

    private boolean cacheModifier(PlayerEntity player, PerkAttributeType type, PerkAttributeModifier modifier) {
        boolean noModifiers = this.getModifiersByType(type, modifier.getMode()).isEmpty();
        List modifiers = this.modifiers.computeIfAbsent(type, t -> Lists.newArrayList());
        if (modifiers.contains((Object)modifier)) {
            return false;
        }
        type.onApply(player, this.side);
        if (noModifiers) {
            type.onModeApply(player, modifier.getMode(), this.side);
        }
        return modifiers.add(modifier);
    }

    void removeModifier(@Nonnull PlayerEntity player, @Nonnull PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
        PlayerProgress prog = ResearchHelper.getProgress(player, this.side);
        ArrayList modify = Lists.newArrayList();
        modify.add(modifier);
        modify.addAll(this.gainModifiers(player, prog, modifier, owningSource));
        Iterator iterator = modify.iterator();
        while (iterator.hasNext()) {
            PerkAttributeModifier mod;
            PerkAttributeModifier preMod = mod = (PerkAttributeModifier)((Object)iterator.next());
            LogCategory.PERKS.info(() -> "Removing unique modifier " + preMod.getComparisonKey());
            PerkAttributeModifier postMod = mod = this.convertModifier(player, prog, mod, owningSource);
            LogCategory.PERKS.info(() -> "Removing converted modifier " + postMod.getComparisonKey());
            if (this.dropModifier(player, mod.getAttributeType(), mod)) continue;
            LogCategory.PERKS.warn(() -> "Could not remove modifier " + postMod.getComparisonKey() + " - not applied!");
        }
    }

    private boolean dropModifier(PlayerEntity player, PerkAttributeType type, PerkAttributeModifier modifier) {
        if (this.modifiers.computeIfAbsent(type, t -> Lists.newArrayList()).remove((Object)modifier)) {
            boolean completelyRemoved = this.modifiers.get((Object)type).isEmpty();
            type.onRemove(player, this.side, completelyRemoved);
            if (this.getModifiersByType(type, modifier.getMode()).isEmpty()) {
                type.onModeRemove(player, modifier.getMode(), this.side, completelyRemoved);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private PerkAttributeModifier convertModifier(@Nonnull PlayerEntity player, @Nonnull PlayerProgress progress, @Nonnull PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
        for (PerkConverter converter : this.converters) {
            modifier = converter.convertModifier(player, progress, modifier, owningSource);
        }
        return modifier;
    }

    @Nonnull
    private Collection<PerkAttributeModifier> gainModifiers(@Nonnull PlayerEntity player, @Nonnull PlayerProgress progress, @Nonnull PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
        ArrayList modifiers = Lists.newArrayList();
        for (PerkConverter converter : this.converters) {
            modifiers.addAll(converter.gainExtraModifiers(player, progress, modifier, owningSource));
        }
        return modifiers;
    }

    boolean applyConverter(PlayerEntity player, PerkConverter converter) {
        this.assertConvertersModifiable();
        LogCategory.PERKS.info(() -> "Try adding converter " + converter.getRegistryName() + " on " + this.side.name());
        if (this.converters.contains((Object)converter)) {
            return false;
        }
        this.converters.add(converter);
        converter.onApply(player, this.side);
        LogCategory.PERKS.info(() -> "Added converter " + converter.getRegistryName());
        return true;
    }

    boolean removeConverter(PlayerEntity player, PerkConverter converter) {
        this.assertConvertersModifiable();
        LogCategory.PERKS.info(() -> "Try removing converter " + converter.getRegistryName() + " on " + this.side.name());
        if (this.converters.remove((Object)converter)) {
            converter.onRemove(player, this.side);
            LogCategory.PERKS.info(() -> "Removed converter " + converter.getRegistryName());
            return true;
        }
        return false;
    }

    void assertConvertersModifiable() {
        int appliedModifiers = 0;
        for (List<PerkAttributeModifier> modifiers : this.modifiers.values()) {
            appliedModifiers += modifiers.size();
        }
        if (appliedModifiers > 0) {
            LogCategory.PERKS.warn(() -> "Following modifiers are still applied on " + this.side.name() + " while trying to modify converters:");
            for (List<PerkAttributeModifier> modifiers : this.modifiers.values()) {
                for (PerkAttributeModifier modifier : modifiers) {
                    LogCategory.PERKS.warn(() -> "Modifier: " + modifier.getComparisonKey());
                }
            }
            throw new IllegalStateException("Trying to modify PerkConverters while modifiers are applied!");
        }
    }

    private List<PerkAttributeModifier> getModifiersByType(PerkAttributeType type, ModifierType mode) {
        return this.modifiers.computeIfAbsent(type, t -> Lists.newArrayList()).stream().filter(mod -> mod.getMode() == mode).collect(Collectors.toList());
    }

    public float getModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeType type) {
        return this.getModifier(player, progress, type, Arrays.asList(ModifierType.values()));
    }

    public float getModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeType type, ModifierType mode) {
        return this.getModifier(player, progress, type, Lists.newArrayList((Object[])new ModifierType[]{mode}));
    }

    public float getModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeType type, Collection<ModifierType> applicableModes) {
        float mod = 1.0f;
        float perkEffectModifier = 1.0f;
        if (!type.equals((Object)PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT)) {
            perkEffectModifier = this.modifyValue(player, progress, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, 1.0f);
        }
        if (applicableModes.contains((Object)ModifierType.ADDITION)) {
            for (PerkAttributeModifier perkAttributeModifier : this.getModifiersByType(type, ModifierType.ADDITION)) {
                mod += perkAttributeModifier.getValue(player, progress) * perkEffectModifier;
            }
        }
        if (applicableModes.contains((Object)ModifierType.ADDED_MULTIPLY)) {
            float multiply = mod;
            for (PerkAttributeModifier modifier : this.getModifiersByType(type, ModifierType.ADDED_MULTIPLY)) {
                mod += multiply * (modifier.getValue(player, progress) * perkEffectModifier);
            }
        }
        if (applicableModes.contains((Object)ModifierType.STACKING_MULTIPLY)) {
            for (PerkAttributeModifier perkAttributeModifier : this.getModifiersByType(type, ModifierType.STACKING_MULTIPLY)) {
                mod *= (perkAttributeModifier.getValue(player, progress) - 1.0f) * perkEffectModifier + 1.0f;
            }
        }
        return mod;
    }

    public float modifyValue(PlayerEntity player, PlayerProgress progress, PerkAttributeType type, float value) {
        float perkEffectModifier = 1.0f;
        if (!type.equals((Object)PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT)) {
            perkEffectModifier = this.modifyValue(player, progress, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, 1.0f);
        }
        for (PerkAttributeModifier mod : this.getModifiersByType(type, ModifierType.ADDITION)) {
            value += mod.getValue(player, progress) * perkEffectModifier;
        }
        float multiply = value;
        for (PerkAttributeModifier mod : this.getModifiersByType(type, ModifierType.ADDED_MULTIPLY)) {
            value += multiply * (mod.getValue(player, progress) * perkEffectModifier);
        }
        for (PerkAttributeModifier mod : this.getModifiersByType(type, ModifierType.STACKING_MULTIPLY)) {
            value *= (mod.getValue(player, progress) - 1.0f) * perkEffectModifier + 1.0f;
        }
        return value;
    }
}

