/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.CooldownPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.util.tick.TimeoutListContainer;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class PerkCooldownHelper {
    private static TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> perkCooldowns = new TimeoutListContainer<PlayerWrapperContainer, ResourceLocation>(new PerkTimeoutHandler(), TickEvent.Type.SERVER);
    private static TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> perkCooldownsClient = new TimeoutListContainer<PlayerWrapperContainer, ResourceLocation>(new PerkTimeoutHandler(), TickEvent.Type.CLIENT);

    private PerkCooldownHelper() {
    }

    public static void attachTickListeners(Consumer<ITickHandler> registrar) {
        registrar.accept(perkCooldowns);
        registrar.accept(perkCooldownsClient);
    }

    public static void clearCache(LogicalSide side) {
        if (side.isClient()) {
            perkCooldownsClient.clear();
        } else {
            perkCooldowns.clear();
        }
    }

    public static void removeAllCooldowns(PlayerEntity player, LogicalSide side) {
        PlayerWrapperContainer ct = new PlayerWrapperContainer(player);
        if (side.isClient()) {
            if (perkCooldownsClient.hasList(ct)) {
                perkCooldownsClient.removeList(ct);
            }
        } else if (perkCooldowns.hasList(ct)) {
            perkCooldowns.removeList(ct);
        }
    }

    public static boolean isCooldownActiveForPlayer(PlayerEntity player, AbstractPerk perk) {
        if (!(perk instanceof CooldownPerk)) {
            return false;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        PlayerWrapperContainer ct = new PlayerWrapperContainer(player);
        return container.hasList(ct) && container.getOrCreateList(ct).contains(perk.getRegistryName());
    }

    public static void setCooldownActiveForPlayer(PlayerEntity player, AbstractPerk perk, int cooldownTicks) {
        if (!(perk instanceof CooldownPerk)) {
            return;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        PlayerWrapperContainer ct = new PlayerWrapperContainer(player);
        container.getOrCreateList(ct).setOrAddTimeout(cooldownTicks, perk.getRegistryName());
    }

    public static void forceSetCooldownForPlayer(PlayerEntity player, AbstractPerk perk, int cooldownTicks) {
        PlayerWrapperContainer ct;
        if (!(perk instanceof CooldownPerk)) {
            return;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.getOrCreateList(ct = new PlayerWrapperContainer(player)).setTimeout(cooldownTicks, perk.getRegistryName())) {
            PerkCooldownHelper.setCooldownActiveForPlayer(player, perk, cooldownTicks);
        }
    }

    public static int getActiveCooldownForPlayer(PlayerEntity player, AbstractPerk perk) {
        PlayerWrapperContainer ct;
        if (!(perk instanceof CooldownPerk)) {
            return -1;
        }
        TimeoutListContainer<PlayerWrapperContainer, ResourceLocation> container = player.func_130014_f_().field_72995_K ? perkCooldownsClient : perkCooldowns;
        if (!container.hasList(ct = new PlayerWrapperContainer(player))) {
            return -1;
        }
        return container.getOrCreateList(ct).getTimeout(perk.getRegistryName());
    }

    public static class PlayerWrapperContainer {
        @Nonnull
        public final PlayerEntity player;

        public PlayerWrapperContainer(@Nonnull PlayerEntity player) {
            this.player = player;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PlayerWrapperContainer)) {
                return false;
            }
            return ((PlayerWrapperContainer)obj).player.func_110124_au().equals(this.player.func_110124_au());
        }

        public int hashCode() {
            return this.player.func_110124_au().hashCode();
        }
    }

    public static class PerkTimeoutHandler
    implements TimeoutListContainer.ContainerTimeoutDelegate<PlayerWrapperContainer, ResourceLocation> {
        @Override
        public void onContainerTimeout(PlayerWrapperContainer plWrapper, ResourceLocation key) {
            LogicalSide side = plWrapper.player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
            PerkTree.PERK_TREE.getPerk(side, key).ifPresent(perk -> {
                if (perk instanceof CooldownPerk) {
                    ((CooldownPerk)((Object)perk)).onCooldownTimeout(plWrapper.player);
                }
            });
        }
    }
}

