/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ProgressGatedPerk
extends AbstractPerk {
    private BiPredicate<PlayerEntity, PlayerProgress> unlockFunction = (player, progress) -> true;
    private List<IConstellation> neededConstellations = new ArrayList<IConstellation>();
    private List<ResearchProgression> neededResearch = new ArrayList<ResearchProgression>();
    private List<ProgressionTier> neededProgression = new ArrayList<ProgressionTier>();

    public ProgressGatedPerk(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    public void addRequireConstellation(IConstellation cst) {
        this.addResearchPreRequisite((player, progress) -> progress.hasConstellationDiscovered(cst));
        this.neededConstellations.add(cst);
    }

    public void addRequireProgress(ResearchProgression research) {
        this.addResearchPreRequisite((player, progress) -> progress.getResearchProgression().contains((Object)research));
        this.neededResearch.add(research);
    }

    public void addRequireTier(ProgressionTier tier) {
        this.addResearchPreRequisite((player, progress) -> progress.getTierReached().isThisLaterOrEqual(tier));
        this.neededProgression.add(tier);
    }

    public void addResearchPreRequisite(BiPredicate<PlayerEntity, PlayerProgress> unlockFunction) {
        this.unlockFunction = this.unlockFunction.and(unlockFunction);
        this.disableTooltipCaching();
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, PlayerEntity player) {
        if (!this.canSee(player, progress)) {
            return false;
        }
        return super.mayUnlockPerk(progress, player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean addLocalizedTooltip(Collection<ITextComponent> tooltip) {
        if (!this.canSeeClient()) {
            tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.missing_progress", new Object[0]).func_211708_a(TextFormatting.RED));
            return false;
        }
        return super.addLocalizedTooltip(tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final boolean canSeeClient() {
        return this.canSee((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
    }

    public final boolean canSee(PlayerEntity player, LogicalSide side) {
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (prog.isValid()) {
            return this.canSee(player, prog);
        }
        return false;
    }

    public final boolean canSee(PlayerEntity player, PlayerProgress progress) {
        return this.unlockFunction.test(player, progress);
    }

    @Override
    public void deserializeData(JsonObject perkData) {
        String key;
        JsonElement el;
        int i;
        JsonArray array;
        super.deserializeData(perkData);
        this.neededConstellations.clear();
        this.neededResearch.clear();
        this.neededProgression.clear();
        if (JSONUtils.func_151204_g((JsonObject)perkData, (String)"neededConstellations")) {
            array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"neededConstellations");
            for (i = 0; i < array.size(); ++i) {
                el = array.get(i);
                key = JSONUtils.func_151206_a((JsonElement)el, (String)String.format("neededConstellations[%s]", i));
                IConstellation cst = ConstellationRegistry.getConstellation(new ResourceLocation(key));
                if (cst == null) {
                    throw new JsonParseException("Unknown constellation: " + key);
                }
                this.addRequireConstellation(cst);
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)perkData, (String)"neededResearch")) {
            array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"neededResearch");
            for (i = 0; i < array.size(); ++i) {
                el = array.get(i);
                key = JSONUtils.func_151206_a((JsonElement)el, (String)String.format("neededResearch[%s]", i));
                try {
                    this.addRequireProgress(ResearchProgression.valueOf(key));
                    continue;
                }
                catch (Exception exc) {
                    throw new JsonParseException("Unknown research: " + key);
                }
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)perkData, (String)"neededProgression")) {
            array = JSONUtils.func_151214_t((JsonObject)perkData, (String)"neededProgression");
            for (i = 0; i < array.size(); ++i) {
                el = array.get(i);
                key = JSONUtils.func_151206_a((JsonElement)el, (String)String.format("neededProgression[%s]", i));
                try {
                    this.addRequireTier(ProgressionTier.valueOf(key));
                    continue;
                }
                catch (Exception exc) {
                    throw new JsonParseException("Unknown progress: " + key);
                }
            }
        }
    }

    @Override
    public void serializeData(JsonObject perkData) {
        JsonArray array;
        super.serializeData(perkData);
        if (!this.neededConstellations.isEmpty()) {
            array = new JsonArray();
            for (IConstellation cst : this.neededConstellations) {
                array.add(cst.getRegistryName().toString());
            }
            perkData.add("neededConstellations", (JsonElement)array);
        }
        if (!this.neededResearch.isEmpty()) {
            array = new JsonArray();
            for (ResearchProgression research : this.neededResearch) {
                array.add(research.name());
            }
            perkData.add("neededResearch", (JsonElement)array);
        }
        if (!this.neededProgression.isEmpty()) {
            array = new JsonArray();
            for (ProgressionTier progress : this.neededProgression) {
                array.add(progress.name());
            }
            perkData.add("neededProgression", (JsonElement)array);
        }
    }
}

