/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.modifier;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DynamicAttributeModifier
extends PerkAttributeModifier {
    private final UUID uuid;
    private PerkAttributeModifier actualModifier = null;
    private static Map<UUID, Map<PerkConverter, Table<PerkAttributeType, ModifierType, PerkAttributeModifier>>> gemConverterCache = Maps.newHashMap();

    public DynamicAttributeModifier(UUID uniqueId, PerkAttributeType type, ModifierType mode, float value) {
        super(type, mode, value);
        this.uuid = uniqueId;
    }

    @Override
    protected void initModifier() {
        super.initModifier();
        this.setAbsolute();
    }

    @Override
    @Nonnull
    public PerkAttributeModifier convertModifier(PerkAttributeType type, ModifierType mode, float value) {
        PerkAttributeModifier mod = super.convertModifier(type, mode, value);
        return new DynamicAttributeModifier(this.getUniqueId(), mod.getAttributeType(), mod.getMode(), mod.getRawValue());
    }

    @Override
    @Nullable
    protected PerkAttributeModifier getCachedAttributeModifier(PerkConverter converter, PerkAttributeType type, ModifierType mode) {
        Map modifierCache = gemConverterCache.computeIfAbsent(this.getUniqueId(), u -> new HashMap());
        Table cachedModifiers = modifierCache.computeIfAbsent(converter, c -> HashBasedTable.create());
        return (PerkAttributeModifier)((Object)cachedModifiers.get((Object)type, (Object)mode));
    }

    @Override
    protected void addModifierToCache(PerkConverter converter, PerkAttributeType type, ModifierType mode, PerkAttributeModifier modifier) {
        Map modifierCache = gemConverterCache.computeIfAbsent(this.getUniqueId(), u -> new HashMap());
        Table cachedModifiers = modifierCache.computeIfAbsent(converter, c -> HashBasedTable.create());
        cachedModifiers.put((Object)type, (Object)mode, (Object)modifier);
    }

    private boolean resolveModifier() {
        if (this.actualModifier != null) {
            return true;
        }
        this.actualModifier = this.attributeType.createModifier(this.value, this.mode);
        this.actualModifier.setAbsolute();
        return true;
    }

    @Override
    public float getValue(PlayerEntity player, PlayerProgress progress) {
        if (!this.resolveModifier()) {
            return super.getValue(player, progress);
        }
        return this.actualModifier.getValue(player, progress);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getValueForDisplay(PlayerEntity player, PlayerProgress progress) {
        if (!this.resolveModifier()) {
            return super.getValueForDisplay(player, progress);
        }
        return this.actualModifier.getValueForDisplay(player, progress);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getAttributeDisplayFormat() {
        if (!this.resolveModifier()) {
            return super.getAttributeDisplayFormat();
        }
        return this.actualModifier.getAttributeDisplayFormat();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getUnlocalizedAttributeName() {
        if (!this.resolveModifier()) {
            return super.getUnlocalizedAttributeName();
        }
        return this.actualModifier.getUnlocalizedAttributeName();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasDisplayString() {
        if (!this.resolveModifier()) {
            return super.hasDisplayString();
        }
        return this.actualModifier.hasDisplayString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedAttributeValue() {
        if (!this.resolveModifier()) {
            return super.getLocalizedAttributeValue();
        }
        return this.actualModifier.getLocalizedAttributeValue();
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedDisplayString() {
        if (!this.resolveModifier()) {
            return super.getLocalizedDisplayString();
        }
        return this.actualModifier.getLocalizedDisplayString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getLocalizedModifierName() {
        if (!this.resolveModifier()) {
            return super.getLocalizedModifierName();
        }
        return this.actualModifier.getLocalizedModifierName();
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_186854_a("id", this.getUniqueId());
        tag.func_74778_a("type", this.getAttributeType().getRegistryName().toString());
        tag.func_74768_a("mode", this.getMode().ordinal());
        tag.func_74776_a("baseValue", this.value);
        return tag;
    }

    @Nullable
    public static DynamicAttributeModifier deserialize(CompoundNBT tag) {
        PerkAttributeType attrType = (PerkAttributeType)RegistriesAS.REGISTRY_PERK_ATTRIBUTE_TYPES.getValue(new ResourceLocation(tag.func_74779_i("type")));
        if (attrType == null) {
            return null;
        }
        UUID id = tag.func_186857_a("id");
        ModifierType mode = ModifierType.values()[tag.func_74762_e("mode")];
        float val = tag.func_74760_g("baseValue");
        return new DynamicAttributeModifier(id, attrType, mode, val);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DynamicAttributeModifier that = (DynamicAttributeModifier)((Object)o);
        return this.uuid.equals(that.uuid);
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }
}

