/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.gem.ItemPerkGem;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.DynamicModifierHelper;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public interface GemSlotPerk {
    public static final String SOCKET_DATA_KEY = "socketedItem";

    default public boolean hasItem(PlayerEntity player, LogicalSide side) {
        return this.hasItem(player, side, null);
    }

    default public boolean hasItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT data) {
        return !this.getContainedItem(player, side, data).func_190926_b();
    }

    default public ItemStack getContainedItem(PlayerEntity player, LogicalSide side) {
        return this.getContainedItem(player, side, null);
    }

    default public ItemStack getContainedItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT dataOvr) {
        CompoundNBT data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        CompoundNBT compoundNBT = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = NBTHelper.getStack(data, SOCKET_DATA_KEY);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    default public boolean setContainedItem(PlayerEntity player, LogicalSide side, ItemStack stack) {
        return this.setContainedItem(player, side, null, stack);
    }

    default public boolean setContainedItem(PlayerEntity player, LogicalSide side, @Nullable CompoundNBT dataOvr, ItemStack stack) {
        CompoundNBT data;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.hasPerkUnlocked((AbstractPerk)((Object)this))) {
            return false;
        }
        boolean updateData = dataOvr == null;
        CompoundNBT compoundNBT = data = dataOvr != null ? dataOvr : ((AbstractPerk)((Object)this)).getPerkData(player, side);
        if (data == null) {
            return false;
        }
        CompoundNBT prev = data.func_74737_b();
        if (stack.func_190926_b()) {
            data.func_82580_o(SOCKET_DATA_KEY);
        } else {
            NBTHelper.setStack(data, SOCKET_DATA_KEY, stack);
        }
        if (updateData) {
            ResearchManager.setPerkData(player, (AbstractPerk)((Object)this), prev, data);
        }
        return true;
    }

    default public void dropItemToPlayer(PlayerEntity player) {
        this.dropItemToPlayer(player, null);
    }

    default public void dropItemToPlayer(PlayerEntity player, @Nullable CompoundNBT data) {
        boolean updateData;
        if (!(this instanceof AbstractPerk)) {
            throw new UnsupportedOperationException("Cannot do perk-specific socketing logic on something that's not a perk!");
        }
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        boolean bl = updateData = data == null;
        if (updateData) {
            data = ((AbstractPerk)((Object)this)).getPerkData(player, LogicalSide.SERVER);
        }
        if (data == null) {
            return;
        }
        CompoundNBT prev = data.func_74737_b();
        ItemStack contained = this.getContainedItem(player, LogicalSide.SERVER, data);
        if (!contained.func_190926_b() && !player.func_191521_c(contained)) {
            ItemUtils.dropItem(player.func_130014_f_(), player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), contained);
        }
        this.setContainedItem(player, LogicalSide.SERVER, data, ItemStack.field_190927_a);
        if (updateData) {
            ResearchManager.setPerkData(player, (AbstractPerk)((Object)this), prev, data);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addTooltipInfo(Collection<ITextComponent> tooltip) {
        if (!(this instanceof AbstractPerk)) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getClientProgress();
        if (!prog.isValid()) {
            return;
        }
        Style gray = new Style().func_150238_a(TextFormatting.GRAY);
        ItemStack contained = this.getContainedItem((PlayerEntity)Minecraft.func_71410_x().field_71439_g, LogicalSide.CLIENT);
        if (contained.func_190926_b()) {
            tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.empty", new Object[0]).func_150255_a(gray));
            if (prog.hasPerkEffect((AbstractPerk)((Object)this))) {
                boolean has;
                tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.empty", new Object[0]).func_150255_a(gray));
                boolean bl = has = !ItemUtils.findItemsIndexedInPlayerInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g, s -> !s.func_190926_b() && s.func_77973_b() instanceof ItemPerkGem && !DynamicModifierHelper.getStaticModifiers(s).isEmpty()).isEmpty();
                if (!has) {
                    tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.empty.none", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        } else {
            tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.content.item", new Object[]{contained.func_200301_q()}).func_150255_a(gray));
            if (prog.hasPerkEffect((AbstractPerk)((Object)this))) {
                tooltip.add(new TranslationTextComponent("perk.info.astralsorcery.gem.remove", new Object[0]).func_150255_a(gray));
            }
        }
    }
}

