/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyAddEnchantment;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyAreaOfEffect
extends KeyAddEnchantment {
    public KeyAreaOfEffect(ResourceLocation name, float x, float y) {
        super(name, x, y);
        this.addEnchantment(Enchantments.field_191530_r, 2);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(EventPriority.HIGH, this::onDamage);
    }

    private void onDamage(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        if (EventFlags.SWEEP_ATTACK.isSet()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).hasPerkEffect(this)) {
            LivingEntity attacked = event.getEntityLiving();
            float sweepPerc = EnchantmentHelper.func_191527_a((LivingEntity)player);
            if (sweepPerc > 0.0f) {
                sweepPerc = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, sweepPerc);
                float toApply = event.getAmount() * sweepPerc;
                float range = 2.5f * PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
                EventFlags.SWEEP_ATTACK.executeWithFlag(() -> {
                    for (LivingEntity target : attacked.func_130014_f_().func_217357_a(LivingEntity.class, attacked.func_174813_aQ().func_72314_b((double)range, (double)(range / 2.0f), (double)range))) {
                        if (!MiscUtils.canPlayerAttackServer((LivingEntity)player, target) || player.equals((Object)target)) continue;
                        DamageUtil.attackEntityFrom((Entity)target, source, toApply);
                    }
                });
            }
        }
    }
}

