/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyCleanseBadPotions
extends KeyPerk {
    public KeyCleanseBadPotions(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(EventPriority.LOW, this::onHeal);
    }

    private void onHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && !entity.field_70170_p.func_201670_d()) {
            PlayerEntity player = (PlayerEntity)entity;
            List badEffects = player.func_70651_bq().stream().filter(p -> p.func_188419_a().func_220303_e() == EffectType.HARMFUL).collect(Collectors.toList());
            if (badEffects.isEmpty()) {
                return;
            }
            EffectInstance effect = (EffectInstance)badEffects.get(rand.nextInt(badEffects.size()));
            PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
            if (prog.hasPerkEffect(this)) {
                float inclChance = 0.1f;
                inclChance = PerkAttributeHelper.getOrCreateMap(player, LogicalSide.SERVER).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, inclChance);
                float chance = this.getChance(event.getAmount()) * inclChance;
                if (rand.nextFloat() < chance) {
                    player.func_195063_d(effect.func_188419_a());
                }
            }
        }
    }

    private float getChance(float healed) {
        if (healed <= 0.0f) {
            return 0.0f;
        }
        float chance = (3.0f / (healed * -0.6666667f) + 5.0f) / 5.0f;
        return MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
    }
}

