/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyLastBreath
extends KeyPerk {
    private static final float defaultDigSpeedMultiplier = 1.5f;
    private static final float defaultDamageMultiplier = 3.0f;
    public static final Config CONFIG = new Config("key.last_breath");

    public KeyLastBreath(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(this::onAttack);
        bus.addListener(this::onBreakSpeed);
    }

    private void onAttack(LivingHurtEvent event) {
        LogicalSide side;
        PlayerEntity player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity && (prog = ResearchHelper.getProgress(player = (PlayerEntity)source.func_76346_g(), side = this.getSide((Entity)player))).hasPerkEffect(this)) {
            float actIncrease = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, (float)this.applyMultiplierD((Double)CONFIG.damageMultiplier.get()));
            float healthPerc = 1.0f - player.func_110143_aJ() / player.func_110138_aP();
            event.setAmount(event.getAmount() * (1.0f + healthPerc * actIncrease));
        }
    }

    private void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        LogicalSide side;
        PlayerEntity player = event.getPlayer();
        PlayerProgress prog = ResearchHelper.getProgress(player, side = this.getSide((Entity)player));
        if (prog.hasPerkEffect(this)) {
            float actIncrease = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, (float)this.applyMultiplierD((Double)CONFIG.digSpeedMultiplier.get()));
            float healthPerc = 1.0f - player.func_110143_aJ() / player.func_110138_aP();
            event.setNewSpeed(event.getNewSpeed() * (1.0f + healthPerc * actIncrease));
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue digSpeedMultiplier;
        private ForgeConfigSpec.DoubleValue damageMultiplier;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.digSpeedMultiplier = cfgBuilder.comment("Defines the dig speed multiplier you get additionally to your normal dig speed when being low on health (25% health = 75% of this additional multiplier)").translation(this.translationKey("digSpeedMultiplier")).defineInRange("digSpeedMultiplier", 1.5, 0.1, 10.0);
            this.damageMultiplier = cfgBuilder.comment("Defines the damage multiplier you get additionally to your normal damage when being low on health (25% health = 75% of this additional multiplier)").translation(this.translationKey("damageMultiplier")).defineInRange("damageMultiplier", 3.0, 0.1, 10.0);
        }
    }
}

