/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.config.registry.TechnicalEntityRegistry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;

public class KeyLightningArc
extends KeyPerk {
    private static final float defaultArcChance = 0.6f;
    private static final float defaultArcPercent = 0.6f;
    private static final float defaultArcDistance = 7.0f;
    private static final int defaultArcTicks = 3;
    private static final int defaultChargeCost = 60;
    private static final int arcChains = 3;
    public static final Config CONFIG = new Config("key.lightning_arc");

    public KeyLightningArc(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(EventPriority.LOWEST, this::onAttack);
    }

    private void onAttack(LivingHurtEvent event) {
        if (EventFlags.LIGHTNING_ARC.isSet()) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            LogicalSide side = this.getSide((Entity)player);
            PlayerProgress prog = ResearchHelper.getProgress(player, side);
            if (side.isServer() && prog.hasPerkEffect(this) && prog.doPerkAbilities()) {
                float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, (float)this.applyMultiplierD((Double)CONFIG.arcChance.get()));
                if (rand.nextFloat() < chance && AlignmentChargeHandler.INSTANCE.drainCharge(player, side, ((Integer)CONFIG.chargeCost.get()).intValue(), false)) {
                    float dmg = event.getAmount();
                    dmg = (float)((double)dmg * this.applyMultiplierD((Double)CONFIG.arcPercent.get()));
                    new RepetitiveArcEffect(player.field_70170_p, player, this.applyMultiplierI(((Integer)CONFIG.arcTicks.get()).intValue()), event.getEntityLiving().func_145782_y(), dmg, this.applyMultiplierD((Double)CONFIG.arcDistance.get())).fire();
                }
            }
        }
    }

    static class RepetitiveArcEffect {
        private final World world;
        private final PlayerEntity player;
        private final int entityStartId;
        private final float damage;
        private final double distance;
        private int count;

        public RepetitiveArcEffect(World world, PlayerEntity player, int count, int entityStartId, float damage, double distance) {
            this.world = world;
            this.player = player;
            this.count = count;
            this.entityStartId = entityStartId;
            this.damage = damage;
            this.distance = distance;
        }

        void fire() {
            if (!this.player.func_70089_S()) {
                return;
            }
            int chainTimes = Math.round(PerkAttributeHelper.getOrCreateMap(this.player, LogicalSide.SERVER).modifyValue(this.player, ResearchHelper.getProgress(this.player, LogicalSide.SERVER), PerkAttributeTypesAS.ATTR_TYPE_ARC_CHAINS, 3.0f));
            ArrayList visitedEntities = Lists.newArrayList();
            Entity start = this.world.func_73045_a(this.entityStartId);
            if (start instanceof LivingEntity && start.func_70089_S()) {
                AxisAlignedBB box = new AxisAlignedBB(-this.distance, -this.distance, -this.distance, this.distance, this.distance, this.distance);
                LivingEntity last = null;
                LivingEntity entity = (LivingEntity)start;
                while (entity != null && entity.func_70089_S() && chainTimes > 0) {
                    visitedEntities.add(entity);
                    --chainTimes;
                    if (last != null) {
                        Vector3 from = Vector3.atEntityCenter((Entity)entity);
                        Vector3 to = Vector3.atEntityCenter(last);
                        PacketDistributor.TargetPoint target = PacketChannel.pointFromPos((IWorld)this.world, (Vec3i)entity.func_180425_c(), 16.0);
                        PacketChannel.CHANNEL.sendToAllAround(new PktPlayEffect(PktPlayEffect.Type.LIGHTNING).addData(buf -> {
                            ByteBufUtils.writeVector(buf, from);
                            ByteBufUtils.writeVector(buf, to);
                            buf.writeInt(ColorsAS.EFFECT_LIGHTNING.getRGB());
                        }), target);
                        PacketChannel.CHANNEL.sendToAllAround(new PktPlayEffect(PktPlayEffect.Type.LIGHTNING).addData(buf -> {
                            ByteBufUtils.writeVector(buf, to);
                            ByteBufUtils.writeVector(buf, from);
                            buf.writeInt(ColorsAS.EFFECT_LIGHTNING.getRGB());
                        }), target);
                    }
                    List entities = entity.func_130014_f_().func_175647_a(LivingEntity.class, box.func_191194_a(entity.func_174791_d()), EntityUtils.selectEntities(LivingEntity.class));
                    entities.remove(entity);
                    if (last != null) {
                        entities.remove(last);
                    }
                    entities.remove(this.player);
                    entities.removeAll(visitedEntities);
                    entities.removeIf(e -> !TechnicalEntityRegistry.INSTANCE.canAffect((Entity)e));
                    entities.removeIf(e -> !MiscUtils.canPlayerAttackServer((LivingEntity)this.player, e));
                    if (!entities.isEmpty()) {
                        LivingEntity tmpEntity = entity;
                        LivingEntity closest = EntityUtils.selectClosest(entities, e -> e.func_70032_d((Entity)tmpEntity));
                        if (closest != null && closest.func_70089_S()) {
                            last = entity;
                            entity = closest;
                            continue;
                        }
                        entity = null;
                        continue;
                    }
                    entity = null;
                }
                if (visitedEntities.size() > 1) {
                    visitedEntities.forEach(e -> EventFlags.LIGHTNING_ARC.executeWithFlag(() -> DamageUtil.attackEntityFrom((Entity)e, CommonProxy.DAMAGE_SOURCE_STELLAR, this.damage, (Entity)this.player)));
                }
            }
            if (this.count > 0) {
                --this.count;
                AstralSorcery.getProxy().scheduleDelayed(this::fire, 12);
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue arcChance;
        private ForgeConfigSpec.DoubleValue arcPercent;
        private ForgeConfigSpec.DoubleValue arcDistance;
        private ForgeConfigSpec.IntValue arcTicks;
        private ForgeConfigSpec.IntValue chargeCost;

        public Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.arcChance = cfgBuilder.comment("Sets the chance to spawn a damage-arc effect when an enemy is hit (value is in percent).").translation(this.translationKey("arcChance")).defineInRange("arcChance", (double)0.6f, 0.1, 1.0);
            this.arcPercent = cfgBuilder.comment("Defines the damage-multiplier which gets added to the damage dealt initially.").translation(this.translationKey("arcPercent")).defineInRange("arcPercent", (double)0.6f, 0.1, 8.0);
            this.arcDistance = cfgBuilder.comment("Defines the distance for how far a single arc can jump/search for nearby entities.").translation(this.translationKey("arcDistance")).defineInRange("arcDistance", 7.0, 0.2, 16.0);
            this.arcTicks = cfgBuilder.defineInRange("arcTicks", 3, 1, 32);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per spawned lighning arc.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 60, 1, 500);
        }
    }
}

