/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyRampage
extends KeyPerk {
    private static final float defaultRampageChance = 1.0f;
    private static final int defaultRampageDuration = 100;
    public static final Config CONFIG = new Config("key.rampage");

    public KeyRampage(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(EventPriority.LOWEST, this::onEntityDeath);
    }

    private void onEntityDeath(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            LogicalSide side = this.getSide((Entity)player);
            PlayerProgress prog = ResearchHelper.getProgress(player, side);
            if (side.isServer() && prog.hasPerkEffect(this)) {
                float ch = (float)this.applyMultiplierD((Double)CONFIG.rampageChance.get());
                ch = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ch);
                if (rand.nextFloat() < ch) {
                    int dur = (int)this.applyMultiplierD(((Integer)CONFIG.rampageDuration.get()).intValue());
                    dur = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_RAMPAGE_DURATION, dur));
                    dur = Math.round(PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, dur));
                    if (dur > 0) {
                        player.func_195064_c(new EffectInstance(Effects.field_76424_c, dur, 1, false, false, true));
                        player.func_195064_c(new EffectInstance(Effects.field_76422_e, dur, 1, false, false, true));
                        player.func_195064_c(new EffectInstance(Effects.field_76420_g, dur, 1, false, false, true));
                    }
                }
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue rampageChance;
        private ForgeConfigSpec.IntValue rampageDuration;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.rampageChance = cfgBuilder.comment("Defines the chance to gain rampage buffs when killing a mob").translation(this.translationKey("rampageChance")).defineInRange("rampageChance", 1.0, (double)0.05f, 1.0);
            this.rampageDuration = cfgBuilder.comment("Defines the duration of the rampage in ticks").translation(this.translationKey("rampageDuration")).defineInRange("rampageDuration", 100, 10, 100000);
        }
    }
}

