/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.node.MajorPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public class KeyTreeConnector
extends MajorPerk {
    public KeyTreeConnector(ResourceLocation name, float x, float y) {
        super(name, x, y);
        this.setCategory(CATEGORY_EPIPHANY);
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, PlayerEntity player) {
        if (!progress.hasFreeAllocationPoint(player, this.getSide((Entity)player)) || !this.canSee(player, progress)) {
            return false;
        }
        LogicalSide side = this.getSide((Entity)player);
        boolean hasAllAdjacent = true;
        for (AbstractPerk otherPerks : PerkTree.PERK_TREE.getConnectedPerks(side, this)) {
            if (progress.hasPerkUnlocked(otherPerks)) continue;
            hasAllAdjacent = false;
            break;
        }
        if (!hasAllAdjacent) {
            return PerkTree.PERK_TREE.getPerkPoints(this.getSide((Entity)player)).stream().map(PerkTreePoint::getPerk).filter(perk -> perk instanceof KeyTreeConnector).anyMatch(progress::hasPerkUnlocked);
        }
        return true;
    }

    @Override
    public void onUnlockPerkServer(@Nullable PlayerEntity player, PlayerProgress progress, CompoundNBT dataStorage) {
        super.onUnlockPerkServer(player, progress, dataStorage);
        ListNBT listTokens = new ListNBT();
        for (AbstractPerk otherPerk : PerkTree.PERK_TREE.getConnectedPerks(LogicalSide.SERVER, this)) {
            String token;
            if (!ResearchManager.forceApplyPerk(player, otherPerk) || !ResearchManager.grantFreePerkPoint(player, token = "connector-tk-" + otherPerk.getRegistryName().toString())) continue;
            listTokens.add((Object)StringNBT.func_229705_a_((String)token));
        }
        dataStorage.func_218657_a("pointtokens", (INBT)listTokens);
    }

    @Override
    public void onRemovePerkServer(PlayerEntity player, PlayerProgress progress, CompoundNBT dataStorage) {
        super.onRemovePerkServer(player, progress, dataStorage);
        ListNBT list = dataStorage.func_150295_c("pointtokens", 8);
        for (int i = 0; i < list.size(); ++i) {
            ResearchManager.revokeFreePoint(player, list.func_150307_f(i));
        }
    }

    @Override
    public void clearCaches(LogicalSide side) {
        super.clearCaches(side);
    }
}

