/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.root;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class RootArmara
extends RootPerk {
    public static final RootPerk.Config CONFIG = new RootPerk.Config("root.armara");

    public RootArmara(ResourceLocation name, float x, float y) {
        super(name, CONFIG, ConstellationsAS.armara, x, y);
    }

    @Override
    @Nonnull
    protected DiminishingMultiplier createMultiplier() {
        return new DiminishingMultiplier(2000L, 0.3f, 0.2f, 0.01f);
    }

    @Override
    public void attachListeners(IEventBus bus) {
        super.attachListeners(bus);
        bus.addListener(EventPriority.HIGHEST, this::onHurt);
    }

    private void onHurt(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        LogicalSide side = this.getSide((Entity)player);
        if (!side.isServer()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.hasPerkEffect(this)) {
            return;
        }
        float mul = 0.5f;
        CombatTracker combat = player.func_110142_aN();
        if (combat.field_94552_d) {
            mul = combat.func_180134_f() <= 4800 ? 10.0f : 0.05f;
        } else if (event.getSource().func_76346_g() instanceof LivingEntity) {
            mul = 3.0f;
        }
        float expGain = Math.min(event.getAmount() * mul, 70.0f);
        expGain = (float)((double)expGain * this.getExpMultiplier());
        expGain *= this.getDiminishingReturns(player);
        expGain *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        expGain *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
        expGain = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, expGain);
        ResearchManager.modifyExp(player, expGain);
    }
}

