/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.source;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.event.ASRegistryEvents;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSourceProvider;
import hellfirepvp.astralsorcery.common.perk.source.provider.PerkSourceProvider;
import hellfirepvp.astralsorcery.common.perk.source.provider.equipment.EquipmentSourceProvider;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class ModifierManager
implements ITickHandler {
    public static final ResourceLocation PERK_PROVIDER_KEY = AstralSorcery.key("perks");
    public static final ResourceLocation EQUIPMENT_PROVIDER_KEY = AstralSorcery.key("equipment");
    public static final ModifierManager INSTANCE = new ModifierManager();
    private static Map<ResourceLocation, ModifierSourceProvider<?>> sourceProviders = null;
    private static Map<UUID, Set<ModifierSource>> modifierCache = new HashMap<UUID, Set<ModifierSource>>();
    private static Map<UUID, Set<ModifierSource>> modifierCacheClient = new HashMap<UUID, Set<ModifierSource>>();

    private ModifierManager() {
    }

    public static void init() {
        if (sourceProviders == null) {
            sourceProviders = new HashMap();
            sourceProviders.put(PERK_PROVIDER_KEY, new PerkSourceProvider());
            sourceProviders.put(EQUIPMENT_PROVIDER_KEY, new EquipmentSourceProvider());
            MinecraftForge.EVENT_BUS.post((Event)new ASRegistryEvents.ModifierSourceRegister(sourceProvider -> sourceProviders.put(sourceProvider.getKey(), (ModifierSourceProvider<?>)sourceProvider)));
        }
    }

    @Nullable
    public static ModifierSourceProvider<?> getProvider(ResourceLocation key) {
        return sourceProviders.get(key);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (!side.isServer() || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        for (ModifierSourceProvider<?> sourceProvider : sourceProviders.values()) {
            sourceProvider.update(serverPlayer);
        }
    }

    @Nonnull
    private static Set<ModifierSource> getModifiers(PlayerEntity player, LogicalSide side) {
        if (side.isClient()) {
            return modifierCacheClient.computeIfAbsent(player.func_110124_au(), uuid -> new HashSet());
        }
        return modifierCache.computeIfAbsent(player.func_110124_au(), uuid -> new HashSet());
    }

    @Nonnull
    public static Set<ModifierSource> getAppliedModifiers(PlayerEntity player, LogicalSide side) {
        return new HashSet<ModifierSource>(ModifierManager.getModifiers(player, side));
    }

    public static void addModifier(PlayerEntity player, LogicalSide side, ModifierSource source) {
        Set<ModifierSource> modifiers = ModifierManager.getModifiers(player, side);
        if (!modifiers.contains(source) && modifiers.add(source)) {
            source.onApply(player, side);
        }
    }

    public static void removeModifier(PlayerEntity player, LogicalSide side, ModifierSource source) {
        Set<ModifierSource> modifiers = ModifierManager.getModifiers(player, side);
        if (modifiers.remove(source)) {
            source.onRemove(player, side);
        }
    }

    public static boolean isModifierApplied(PlayerEntity player, LogicalSide side, ModifierSource source) {
        return ModifierManager.getModifiers(player, side).contains(source);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "Modifier Source Manager";
    }
}

