/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.tree;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.journal.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.screen.journal.perk.DynamicPerkRender;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.screen.journal.perk.group.PerkPointHaloRenderGroup;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.draw.BufferContext;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.AllocationStatus;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PerkTreeConstellation<T extends AbstractPerk>
extends PerkTreePoint<T>
implements DynamicPerkRender {
    public static final int ROOT_SPRITE_SIZE = 50;
    public static final int MINOR_SPRITE_SIZE = 40;
    private final IConstellation associatedConstellation;
    private final int perkSpriteSize;

    public PerkTreeConstellation(T perk, Point2D.Float offset, IConstellation associatedConstellation, int perkSpriteSize) {
        super(perk, offset);
        this.associatedConstellation = associatedConstellation;
        this.perkSpriteSize = perkSpriteSize;
        this.setRenderSize(perkSpriteSize / 2);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        super.addGroups(groups);
        groups.add(PerkPointHaloRenderGroup.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAt(AllocationStatus status, long spriteOffsetTick, float pTicks, float x, float y, float zLevel, float scale) {
        if (this.associatedConstellation == null) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getClientProgress();
        if (!prog.hasConstellationDiscovered(this.associatedConstellation)) {
            return;
        }
        float size = (float)this.perkSpriteSize * scale * 0.85f;
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingConstellationUtils.renderConstellationIntoGUI(Color.WHITE, this.associatedConstellation, x - size, y - size, 0.0f, size * 2.0f, size * 2.0f, 3.0f * scale, () -> Float.valueOf(0.8f), true, false);
        RenderSystem.disableBlend();
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle2D.Float renderPerkAtBatch(BatchPerkContext drawCtx, AllocationStatus status, long spriteOffsetTick, float pTicks, float x, float y, float zLevel, float scale) {
        SpriteSheetResource tex = this.getHaloSprite(status);
        BatchPerkContext.TextureObjectGroup grp = PerkPointHaloRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Float();
        }
        BufferContext buf = drawCtx.getContext(grp);
        float haloSize = (float)this.perkSpriteSize * scale;
        if (status == AllocationStatus.ALLOCATED) {
            haloSize *= 1.3f;
        }
        Tuple<Float, Float> frameUV = tex.getUVOffset(spriteOffsetTick);
        RenderingGuiUtils.rect(buf, x - haloSize, y - haloSize, zLevel, haloSize * 2.0f, haloSize * 2.0f).color(1.0f, 1.0f, 1.0f, 0.85f).tex(((Float)frameUV.func_76341_a()).floatValue(), ((Float)frameUV.func_76340_b()).floatValue(), tex.getULength(), tex.getVLength()).draw();
        super.renderPerkAtBatch(drawCtx, status, spriteOffsetTick, pTicks, x, y, zLevel, scale);
        float actualSize = (float)this.perkSpriteSize * scale;
        return new Rectangle2D.Float(-actualSize, -actualSize, actualSize * 2.0f, actualSize * 2.0f);
    }
}

