/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationBase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.TagsAS;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;

public class RegistryConstellations {
    public static void init() {
        RegistryConstellations.buildConstellations();
        RegistryConstellations.registerSignatureItems();
    }

    private static void registerSignatureItems() {
        ConstellationsAS.aevitas.addSignatureItem((Tag<Item>)ItemTags.field_200037_g);
        ConstellationsAS.aevitas.addSignatureItem(TagsAS.Items.DUSTS_STARDUST);
        ConstellationsAS.aevitas.addSignatureItem((Tag<Item>)Tags.Items.SEEDS_WHEAT);
        ConstellationsAS.aevitas.addSignatureItem((IItemProvider)Blocks.field_196608_cF);
        ConstellationsAS.discidia.addSignatureItem((IItemProvider)Items.field_151145_ak);
        ConstellationsAS.discidia.addSignatureItem((Tag<Item>)Tags.Items.INGOTS_IRON);
        ConstellationsAS.discidia.addSignatureItem((Tag<Item>)ItemTags.field_219776_M);
        ConstellationsAS.discidia.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE);
        ConstellationsAS.armara.addSignatureItem((Tag<Item>)Tags.Items.INGOTS_IRON);
        ConstellationsAS.armara.addSignatureItem((Tag<Item>)Tags.Items.LEATHER);
        ConstellationsAS.armara.addSignatureItem((IItemProvider)Items.field_151119_aD);
        ConstellationsAS.armara.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_GLOWSTONE);
        ConstellationsAS.vicio.addSignatureItem((Tag<Item>)Tags.Items.FEATHERS);
        ConstellationsAS.vicio.addSignatureItem((IItemProvider)Items.field_151102_aT);
        ConstellationsAS.vicio.addSignatureItem((IItemProvider)Items.field_151007_F);
        ConstellationsAS.vicio.addSignatureItem((Tag<Item>)ItemTags.field_206964_G);
        ConstellationsAS.evorsio.addSignatureItem((Tag<Item>)Tags.Items.COBBLESTONE);
        ConstellationsAS.evorsio.addSignatureItem((IItemProvider)Items.field_151145_ak);
        ConstellationsAS.evorsio.addSignatureItem((Tag<Item>)Tags.Items.GUNPOWDER);
        ConstellationsAS.evorsio.addSignatureItem((IItemProvider)Blocks.field_150335_W);
        ConstellationsAS.lucerna.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_GLOWSTONE);
        ConstellationsAS.lucerna.addSignatureItem((IItemProvider)Blocks.field_150478_aa);
        ConstellationsAS.lucerna.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE);
        ConstellationsAS.lucerna.addSignatureItem((Tag<Item>)ItemTags.field_219775_L);
        ConstellationsAS.mineralis.addSignatureItem((Tag<Item>)Tags.Items.ORES_IRON);
        ConstellationsAS.mineralis.addSignatureItem((Tag<Item>)Tags.Items.INGOTS_GOLD);
        ConstellationsAS.mineralis.addSignatureItem((Tag<Item>)Tags.Items.INGOTS_IRON);
        ConstellationsAS.mineralis.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE);
        ConstellationsAS.horologium.addSignatureItem(TagsAS.Items.DUSTS_STARDUST);
        ConstellationsAS.horologium.addSignatureItem((Tag<Item>)Tags.Items.GEMS_DIAMOND);
        ConstellationsAS.horologium.addSignatureItem((Tag<Item>)Tags.Items.ENDER_PEARLS);
        ConstellationsAS.horologium.addSignatureItem((IItemProvider)Items.field_151113_aN);
        ConstellationsAS.octans.addSignatureItem((Tag<Item>)ItemTags.field_206964_G);
        ConstellationsAS.octans.addSignatureItem((IItemProvider)Items.field_151112_aM);
        ConstellationsAS.octans.addSignatureItem((Tag<Item>)Tags.Items.DYES_BLUE);
        ConstellationsAS.octans.addSignatureItem((IItemProvider)Items.field_151119_aD);
        ConstellationsAS.bootes.addSignatureItem((Tag<Item>)Tags.Items.CROPS_WHEAT);
        ConstellationsAS.bootes.addSignatureItem((Tag<Item>)Tags.Items.BONES);
        ConstellationsAS.bootes.addSignatureItem((IItemProvider)Items.field_151034_e);
        ConstellationsAS.bootes.addSignatureItem((Tag<Item>)Tags.Items.LEATHER);
        ConstellationsAS.fornax.addSignatureItem((IItemProvider)Items.field_151044_h);
        ConstellationsAS.fornax.addSignatureItem((Tag<Item>)Tags.Items.DUSTS_REDSTONE);
        ConstellationsAS.fornax.addSignatureItem((Tag<Item>)Tags.Items.INGOTS_IRON);
        ConstellationsAS.fornax.addSignatureItem((Tag<Item>)Tags.Items.GUNPOWDER);
        ConstellationsAS.pelotrio.addSignatureItem((IItemProvider)Items.field_151078_bh);
        ConstellationsAS.pelotrio.addSignatureItem((IItemProvider)Items.field_151065_br);
        ConstellationsAS.pelotrio.addSignatureItem((IItemProvider)Items.field_151034_e);
        ConstellationsAS.pelotrio.addSignatureItem((Tag<Item>)Tags.Items.EGGS);
        ConstellationsAS.gelu.addSignatureItem((IItemProvider)Items.field_151126_ay);
        ConstellationsAS.gelu.addSignatureItem((IItemProvider)Blocks.field_150432_aD);
        ConstellationsAS.gelu.addSignatureItem((Tag<Item>)Tags.Items.GEMS_QUARTZ);
        ConstellationsAS.gelu.addSignatureItem((Tag<Item>)Tags.Items.FEATHERS);
        ConstellationsAS.ulteria.addSignatureItem(TagsAS.Items.INGOTS_STARMETAL);
        ConstellationsAS.ulteria.addSignatureItem((Tag<Item>)Tags.Items.LEATHER);
        ConstellationsAS.ulteria.addSignatureItem((Tag<Item>)Tags.Items.GEMS_DIAMOND);
        ConstellationsAS.ulteria.addSignatureItem((Tag<Item>)Tags.Items.RODS_BLAZE);
        ConstellationsAS.alcara.addSignatureItem((Tag<Item>)Tags.Items.CROPS_NETHER_WART);
        ConstellationsAS.alcara.addSignatureItem((Tag<Item>)Tags.Items.ENDER_PEARLS);
        ConstellationsAS.alcara.addSignatureItem((IItemProvider)Blocks.field_150425_aM);
        ConstellationsAS.alcara.addSignatureItem((Tag<Item>)ItemTags.field_219775_L);
        ConstellationsAS.vorux.addSignatureItem((IItemProvider)Items.field_151065_br);
        ConstellationsAS.vorux.addSignatureItem((IItemProvider)ItemsAS.NOCTURNAL_POWDER);
        ConstellationsAS.vorux.addSignatureItem((Tag<Item>)Tags.Items.GUNPOWDER);
        ConstellationsAS.vorux.addSignatureItem((IItemProvider)Items.field_196154_dH);
    }

    private static void buildConstellations() {
        ConstellationsAS.discidia = new ConstellationBase.Major("discidia", ColorsAS.CONSTELLATION_DISCIDIA);
        StarLocation sl1 = ConstellationsAS.discidia.addStar(9, 25);
        StarLocation sl2 = ConstellationsAS.discidia.addStar(6, 18);
        StarLocation sl3 = ConstellationsAS.discidia.addStar(13, 16);
        StarLocation sl4 = ConstellationsAS.discidia.addStar(15, 9);
        StarLocation sl5 = ConstellationsAS.discidia.addStar(22, 8);
        StarLocation sl6 = ConstellationsAS.discidia.addStar(27, 2);
        ConstellationsAS.discidia.addConnection(sl1, sl2);
        ConstellationsAS.discidia.addConnection(sl2, sl3);
        ConstellationsAS.discidia.addConnection(sl1, sl3);
        ConstellationsAS.discidia.addConnection(sl3, sl4);
        ConstellationsAS.discidia.addConnection(sl3, sl5);
        ConstellationsAS.discidia.addConnection(sl4, sl5);
        ConstellationsAS.discidia.addConnection(sl5, sl6);
        RegistryConstellations.register(ConstellationsAS.discidia);
        ConstellationsAS.armara = new ConstellationBase.Major("armara", ColorsAS.CONSTELLATION_ARMARA);
        sl1 = ConstellationsAS.armara.addStar(5, 5);
        sl2 = ConstellationsAS.armara.addStar(7, 16);
        sl3 = ConstellationsAS.armara.addStar(15, 9);
        sl4 = ConstellationsAS.armara.addStar(11, 26);
        sl5 = ConstellationsAS.armara.addStar(16, 27);
        sl6 = ConstellationsAS.armara.addStar(23, 19);
        StarLocation sl7 = ConstellationsAS.armara.addStar(26, 13);
        ConstellationsAS.armara.addConnection(sl1, sl2);
        ConstellationsAS.armara.addConnection(sl2, sl3);
        ConstellationsAS.armara.addConnection(sl1, sl3);
        ConstellationsAS.armara.addConnection(sl2, sl4);
        ConstellationsAS.armara.addConnection(sl4, sl5);
        ConstellationsAS.armara.addConnection(sl5, sl6);
        ConstellationsAS.armara.addConnection(sl3, sl6);
        ConstellationsAS.armara.addConnection(sl6, sl7);
        RegistryConstellations.register(ConstellationsAS.armara);
        ConstellationsAS.vicio = new ConstellationBase.Major("vicio", ColorsAS.CONSTELLATION_VICIO);
        sl1 = ConstellationsAS.vicio.addStar(13, 11);
        sl2 = ConstellationsAS.vicio.addStar(26, 10);
        sl3 = ConstellationsAS.vicio.addStar(23, 4);
        sl4 = ConstellationsAS.vicio.addStar(4, 6);
        sl5 = ConstellationsAS.vicio.addStar(5, 20);
        sl6 = ConstellationsAS.vicio.addStar(12, 25);
        ConstellationsAS.vicio.addConnection(sl1, sl2);
        ConstellationsAS.vicio.addConnection(sl2, sl3);
        ConstellationsAS.vicio.addConnection(sl1, sl3);
        ConstellationsAS.vicio.addConnection(sl1, sl4);
        ConstellationsAS.vicio.addConnection(sl4, sl5);
        ConstellationsAS.vicio.addConnection(sl5, sl6);
        ConstellationsAS.vicio.addConnection(sl6, sl1);
        RegistryConstellations.register(ConstellationsAS.vicio);
        ConstellationsAS.aevitas = new ConstellationBase.Major("aevitas", ColorsAS.CONSTELLATION_AEVITAS);
        sl1 = ConstellationsAS.aevitas.addStar(13, 4);
        sl2 = ConstellationsAS.aevitas.addStar(15, 18);
        sl3 = ConstellationsAS.aevitas.addStar(10, 27);
        sl4 = ConstellationsAS.aevitas.addStar(27, 24);
        sl5 = ConstellationsAS.aevitas.addStar(24, 19);
        sl6 = ConstellationsAS.aevitas.addStar(25, 10);
        sl7 = ConstellationsAS.aevitas.addStar(3, 6);
        ConstellationsAS.aevitas.addConnection(sl1, sl2);
        ConstellationsAS.aevitas.addConnection(sl2, sl3);
        ConstellationsAS.aevitas.addConnection(sl3, sl4);
        ConstellationsAS.aevitas.addConnection(sl4, sl5);
        ConstellationsAS.aevitas.addConnection(sl5, sl6);
        ConstellationsAS.aevitas.addConnection(sl6, sl1);
        ConstellationsAS.aevitas.addConnection(sl1, sl7);
        RegistryConstellations.register(ConstellationsAS.aevitas);
        ConstellationsAS.evorsio = new ConstellationBase.Major("evorsio", ColorsAS.CONSTELLATION_EVORSIO);
        sl1 = ConstellationsAS.evorsio.addStar(27, 17);
        sl2 = ConstellationsAS.evorsio.addStar(19, 23);
        sl3 = ConstellationsAS.evorsio.addStar(25, 27);
        sl4 = ConstellationsAS.evorsio.addStar(22, 12);
        sl5 = ConstellationsAS.evorsio.addStar(13, 3);
        sl6 = ConstellationsAS.evorsio.addStar(16, 11);
        sl7 = ConstellationsAS.evorsio.addStar(6, 5);
        ConstellationsAS.evorsio.addConnection(sl1, sl2);
        ConstellationsAS.evorsio.addConnection(sl1, sl3);
        ConstellationsAS.evorsio.addConnection(sl1, sl4);
        ConstellationsAS.evorsio.addConnection(sl4, sl5);
        ConstellationsAS.evorsio.addConnection(sl4, sl6);
        ConstellationsAS.evorsio.addConnection(sl6, sl7);
        RegistryConstellations.register(ConstellationsAS.evorsio);
        ConstellationsAS.lucerna = new ConstellationBase.Weak("lucerna", ColorsAS.CONSTELLATION_LUCERNA);
        sl1 = ConstellationsAS.lucerna.addStar(19, 4);
        sl2 = ConstellationsAS.lucerna.addStar(25, 14);
        sl3 = ConstellationsAS.lucerna.addStar(22, 22);
        sl4 = ConstellationsAS.lucerna.addStar(15, 25);
        sl5 = ConstellationsAS.lucerna.addStar(8, 23);
        sl6 = ConstellationsAS.lucerna.addStar(4, 12);
        ConstellationsAS.lucerna.addConnection(sl1, sl2);
        ConstellationsAS.lucerna.addConnection(sl2, sl3);
        ConstellationsAS.lucerna.addConnection(sl3, sl4);
        ConstellationsAS.lucerna.addConnection(sl4, sl5);
        ConstellationsAS.lucerna.addConnection(sl5, sl6);
        RegistryConstellations.register(ConstellationsAS.lucerna);
        ConstellationsAS.mineralis = new ConstellationBase.Weak("mineralis", ColorsAS.CONSTELLATION_MINERALIS);
        sl1 = ConstellationsAS.mineralis.addStar(17, 2);
        sl2 = ConstellationsAS.mineralis.addStar(19, 10);
        sl3 = ConstellationsAS.mineralis.addStar(13, 7);
        sl4 = ConstellationsAS.mineralis.addStar(15, 15);
        sl5 = ConstellationsAS.mineralis.addStar(22, 19);
        sl6 = ConstellationsAS.mineralis.addStar(11, 25);
        sl7 = ConstellationsAS.mineralis.addStar(18, 28);
        ConstellationsAS.mineralis.addConnection(sl1, sl2);
        ConstellationsAS.mineralis.addConnection(sl1, sl3);
        ConstellationsAS.mineralis.addConnection(sl4, sl2);
        ConstellationsAS.mineralis.addConnection(sl4, sl3);
        ConstellationsAS.mineralis.addConnection(sl4, sl5);
        ConstellationsAS.mineralis.addConnection(sl4, sl6);
        ConstellationsAS.mineralis.addConnection(sl7, sl5);
        ConstellationsAS.mineralis.addConnection(sl7, sl6);
        RegistryConstellations.register(ConstellationsAS.mineralis);
        ConstellationsAS.horologium = new ConstellationBase.WeakSpecial("horologium", ColorsAS.CONSTELLATION_HOROLOGIUM){

            @Override
            public boolean doesShowUp(World world, long day) {
                WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
                if (ctx != null) {
                    return ctx.getCelestialHandler().isDayOfSolarEclipse();
                }
                return false;
            }

            @Override
            public float getDistribution(World world, long day, boolean showsUp) {
                return showsUp ? 1.0f : 0.25f;
            }
        };
        sl1 = ConstellationsAS.horologium.addStar(25, 28);
        sl2 = ConstellationsAS.horologium.addStar(20, 22);
        sl3 = ConstellationsAS.horologium.addStar(25, 16);
        sl4 = ConstellationsAS.horologium.addStar(27, 10);
        sl5 = ConstellationsAS.horologium.addStar(23, 6);
        sl6 = ConstellationsAS.horologium.addStar(4, 3);
        ConstellationsAS.horologium.addConnection(sl1, sl2);
        ConstellationsAS.horologium.addConnection(sl2, sl3);
        ConstellationsAS.horologium.addConnection(sl3, sl4);
        ConstellationsAS.horologium.addConnection(sl4, sl5);
        ConstellationsAS.horologium.addConnection(sl5, sl6);
        RegistryConstellations.register(ConstellationsAS.horologium);
        ConstellationsAS.octans = new ConstellationBase.Weak("octans", ColorsAS.CONSTELLATION_OCTANS);
        sl1 = ConstellationsAS.octans.addStar(25, 25);
        sl2 = ConstellationsAS.octans.addStar(17, 5);
        sl3 = ConstellationsAS.octans.addStar(11, 10);
        sl4 = ConstellationsAS.octans.addStar(4, 6);
        ConstellationsAS.octans.addConnection(sl1, sl2);
        ConstellationsAS.octans.addConnection(sl1, sl3);
        ConstellationsAS.octans.addConnection(sl2, sl3);
        ConstellationsAS.octans.addConnection(sl3, sl4);
        RegistryConstellations.register(ConstellationsAS.octans);
        ConstellationsAS.bootes = new ConstellationBase.Weak("bootes", ColorsAS.CONSTELLATION_BOOTES);
        sl1 = ConstellationsAS.bootes.addStar(9, 22);
        sl2 = ConstellationsAS.bootes.addStar(3, 14);
        sl3 = ConstellationsAS.bootes.addStar(22, 27);
        sl4 = ConstellationsAS.bootes.addStar(16, 5);
        sl5 = ConstellationsAS.bootes.addStar(26, 3);
        sl6 = ConstellationsAS.bootes.addStar(24, 11);
        ConstellationsAS.bootes.addConnection(sl1, sl2);
        ConstellationsAS.bootes.addConnection(sl1, sl3);
        ConstellationsAS.bootes.addConnection(sl1, sl4);
        ConstellationsAS.bootes.addConnection(sl1, sl6);
        ConstellationsAS.bootes.addConnection(sl4, sl5);
        ConstellationsAS.bootes.addConnection(sl5, sl6);
        RegistryConstellations.register(ConstellationsAS.bootes);
        ConstellationsAS.fornax = new ConstellationBase.Weak("fornax", ColorsAS.CONSTELLATION_FORNAX);
        sl1 = ConstellationsAS.fornax.addStar(18, 29);
        sl2 = ConstellationsAS.fornax.addStar(28, 18);
        sl3 = ConstellationsAS.fornax.addStar(21, 13);
        sl4 = ConstellationsAS.fornax.addStar(16, 18);
        sl5 = ConstellationsAS.fornax.addStar(19, 6);
        sl6 = ConstellationsAS.fornax.addStar(13, 2);
        sl7 = ConstellationsAS.fornax.addStar(9, 21);
        StarLocation sl8 = ConstellationsAS.fornax.addStar(2, 17);
        ConstellationsAS.fornax.addConnection(sl1, sl2);
        ConstellationsAS.fornax.addConnection(sl2, sl3);
        ConstellationsAS.fornax.addConnection(sl3, sl4);
        ConstellationsAS.fornax.addConnection(sl4, sl1);
        ConstellationsAS.fornax.addConnection(sl3, sl5);
        ConstellationsAS.fornax.addConnection(sl5, sl6);
        ConstellationsAS.fornax.addConnection(sl4, sl7);
        ConstellationsAS.fornax.addConnection(sl7, sl8);
        RegistryConstellations.register(ConstellationsAS.fornax);
        ConstellationsAS.pelotrio = new ConstellationBase.WeakSpecial("pelotrio", ColorsAS.CONSTELLATION_PELOTRIO){

            @Override
            public boolean doesShowUp(World world, long day) {
                MoonPhase phase = MoonPhase.fromWorld((IWorld)world);
                return phase == MoonPhase.NEW || phase == MoonPhase.FULL;
            }

            @Override
            public float getDistribution(World world, long day, boolean showingUp) {
                if (showingUp) {
                    return 1.0f;
                }
                MoonPhase current = MoonPhase.fromWorld((IWorld)world);
                if (current == MoonPhase.WANING_1_2 || current == MoonPhase.WAXING_1_2) {
                    return 0.3f;
                }
                return 0.65f;
            }
        };
        sl1 = ConstellationsAS.pelotrio.addStar(17, 24);
        sl2 = ConstellationsAS.pelotrio.addStar(27, 25);
        sl3 = ConstellationsAS.pelotrio.addStar(22, 8);
        sl4 = ConstellationsAS.pelotrio.addStar(14, 14);
        sl5 = ConstellationsAS.pelotrio.addStar(8, 29);
        sl6 = ConstellationsAS.pelotrio.addStar(3, 8);
        sl7 = ConstellationsAS.pelotrio.addStar(9, 10);
        ConstellationsAS.pelotrio.addConnection(sl1, sl2);
        ConstellationsAS.pelotrio.addConnection(sl2, sl3);
        ConstellationsAS.pelotrio.addConnection(sl3, sl4);
        ConstellationsAS.pelotrio.addConnection(sl4, sl1);
        ConstellationsAS.pelotrio.addConnection(sl1, sl5);
        ConstellationsAS.pelotrio.addConnection(sl5, sl6);
        ConstellationsAS.pelotrio.addConnection(sl6, sl7);
        ConstellationsAS.pelotrio.addConnection(sl7, sl4);
        RegistryConstellations.register(ConstellationsAS.pelotrio);
        ConstellationsAS.gelu = new ConstellationBase.Minor("gelu", ColorsAS.CONSTELLATION_GELU, MoonPhase.NEW, MoonPhase.WAXING_1_4, MoonPhase.WAXING_1_2);
        sl1 = ConstellationsAS.gelu.addStar(21, 28);
        sl2 = ConstellationsAS.gelu.addStar(27, 13);
        sl3 = ConstellationsAS.gelu.addStar(29, 4);
        sl4 = ConstellationsAS.gelu.addStar(12, 14);
        sl5 = ConstellationsAS.gelu.addStar(3, 12);
        sl6 = ConstellationsAS.gelu.addStar(9, 21);
        ConstellationsAS.gelu.addConnection(sl1, sl2);
        ConstellationsAS.gelu.addConnection(sl2, sl3);
        ConstellationsAS.gelu.addConnection(sl3, sl4);
        ConstellationsAS.gelu.addConnection(sl4, sl5);
        ConstellationsAS.gelu.addConnection(sl5, sl6);
        ConstellationsAS.gelu.addConnection(sl6, sl1);
        RegistryConstellations.register(ConstellationsAS.gelu);
        ConstellationsAS.ulteria = new ConstellationBase.Minor("ulteria", ColorsAS.CONSTELLATION_ULTERIA, MoonPhase.WANING_1_2, MoonPhase.WANING_3_4, MoonPhase.NEW);
        sl1 = ConstellationsAS.ulteria.addStar(4, 28);
        sl2 = ConstellationsAS.ulteria.addStar(7, 22);
        sl3 = ConstellationsAS.ulteria.addStar(9, 14);
        sl4 = ConstellationsAS.ulteria.addStar(21, 15);
        sl5 = ConstellationsAS.ulteria.addStar(15, 8);
        sl6 = ConstellationsAS.ulteria.addStar(24, 3);
        ConstellationsAS.ulteria.addConnection(sl1, sl2);
        ConstellationsAS.ulteria.addConnection(sl2, sl3);
        ConstellationsAS.ulteria.addConnection(sl3, sl4);
        ConstellationsAS.ulteria.addConnection(sl3, sl5);
        ConstellationsAS.ulteria.addConnection(sl4, sl5);
        ConstellationsAS.ulteria.addConnection(sl5, sl6);
        RegistryConstellations.register(ConstellationsAS.ulteria);
        ConstellationsAS.alcara = new ConstellationBase.Minor("alcara", ColorsAS.CONSTELLATION_ALCARA, MoonPhase.WANING_1_2, MoonPhase.WAXING_1_2);
        sl1 = ConstellationsAS.alcara.addStar(24, 27);
        sl2 = ConstellationsAS.alcara.addStar(17, 16);
        sl3 = ConstellationsAS.alcara.addStar(12, 9);
        sl4 = ConstellationsAS.alcara.addStar(23, 9);
        sl5 = ConstellationsAS.alcara.addStar(21, 2);
        sl6 = ConstellationsAS.alcara.addStar(10, 21);
        sl7 = ConstellationsAS.alcara.addStar(3, 20);
        ConstellationsAS.alcara.addConnection(sl1, sl2);
        ConstellationsAS.alcara.addConnection(sl2, sl3);
        ConstellationsAS.alcara.addConnection(sl2, sl4);
        ConstellationsAS.alcara.addConnection(sl4, sl5);
        ConstellationsAS.alcara.addConnection(sl5, sl3);
        ConstellationsAS.alcara.addConnection(sl2, sl6);
        ConstellationsAS.alcara.addConnection(sl6, sl7);
        ConstellationsAS.alcara.addConnection(sl7, sl3);
        RegistryConstellations.register(ConstellationsAS.alcara);
        ConstellationsAS.vorux = new ConstellationBase.Minor("vorux", ColorsAS.CONSTELLATION_VORUX, MoonPhase.FULL, MoonPhase.WAXING_3_4, MoonPhase.WANING_3_4);
        sl1 = ConstellationsAS.vorux.addStar(7, 29);
        sl2 = ConstellationsAS.vorux.addStar(15, 12);
        sl3 = ConstellationsAS.vorux.addStar(23, 7);
        sl4 = ConstellationsAS.vorux.addStar(28, 14);
        sl5 = ConstellationsAS.vorux.addStar(3, 6);
        ConstellationsAS.vorux.addConnection(sl1, sl2);
        ConstellationsAS.vorux.addConnection(sl2, sl3);
        ConstellationsAS.vorux.addConnection(sl3, sl4);
        ConstellationsAS.vorux.addConnection(sl2, sl5);
        RegistryConstellations.register(ConstellationsAS.vorux);
    }

    private static void register(IConstellation cst) {
        AstralSorcery.getProxy().getRegistryPrimer().register(cst);
    }
}

